/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterTableModel;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.uml.utils.UmlPsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.ColumnInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class CreateNewMethodDialog
extends JavaChangeSignatureDialog {
    private static final Logger LOG = Logger.getInstance((String)CreateNewMethodDialog.class.getName());
    private JCheckBox myAbstractCB;

    public CreateNewMethodDialog(Project project, PsiMethod method, final PsiClass clazz) {
        super(project, new JavaMethodDescriptor(method){

            public boolean canChangeVisibility() {
                return clazz != null && !clazz.isInterface();
            }
        }, false, null);
        this.setTitle(UmlBundle.message(method.isConstructor() ? "create.new.constructor.dialog.title" : "create.new.method.dialog.title", new Object[0]));
        this.getRefactorAction().putValue("Name", UmlBundle.message("create.method", new Object[0]));
    }

    protected JavaParameterTableModel createParametersInfoModel(JavaMethodDescriptor descriptor) {
        return new JavaParameterTableModel((PsiElement)descriptor.getMethod().getParameterList(), this.myDefaultValueContext, new ColumnInfo[]{new JavaParameterTableModel.JavaTypeColumn(descriptor.getMethod().getProject()), new JavaParameterTableModel.JavaNameColumn(descriptor.getMethod().getProject())}){

            protected ParameterTableModelItemBase<ParameterInfoImpl> createRowItem(@Nullable ParameterInfoImpl parameterInfo) {
                if (parameterInfo == null) {
                    parameterInfo = new ParameterInfoImpl(-1);
                    parameterInfo.setDefaultValue("null");
                }
                return super.createRowItem(parameterInfo);
            }
        };
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected LanguageFileType getFileType() {
        return StdFileTypes.JAVA;
    }

    protected JPanel createVisibilityPanel() {
        JPanel visibilityPanel = super.createVisibilityPanel();
        if (((JavaMethodDescriptor)this.myMethod).getMethod().isConstructor()) {
            return visibilityPanel;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)visibilityPanel, "North");
        this.myAbstractCB = new JCheckBox(UmlBundle.message("abstract", new Object[0]));
        this.myAbstractCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CreateNewMethodDialog.this.updateSignature();
            }
        });
        panel.add((Component)this.myAbstractCB, "South");
        return panel;
    }

    protected BaseRefactoringProcessor createRefactoringProcessor() {
        List parameterInfos = this.getParameters();
        for (ParameterInfoImpl parameterInfo : parameterInfos) {
            parameterInfo.setDefaultValue("null");
        }
        return new ChangeSignatureProcessor(this.myProject, ((JavaMethodDescriptor)this.myMethod).getMethod(), false, (String)this.getVisibility(), this.getMethodName(), this.getReturnType(), parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]), this.getExceptions(), this.myMethodsToPropagateParameters, this.myMethodsToPropagateExceptions);
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        super.invokeRefactoring(processor);
        if (this.myAbstractCB != null && this.myAbstractCB.isSelected()) {
            UmlPsiUtil.runWriteActionInCommandProcessor(this.myProject, (PsiElement)((JavaMethodDescriptor)this.myMethod).getMethod(), new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)((JavaMethodDescriptor)CreateNewMethodDialog.this.myMethod).getMethod(), (String)"abstract", (boolean)true);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }

    protected String doCalculateSignature(PsiMethod method) {
        PsiMethod methodCopy = (PsiMethod)method.copy();
        if (this.myAbstractCB != null && this.myAbstractCB.isSelected()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)"abstract", (boolean)true);
        }
        return super.doCalculateSignature(methodCopy);
    }
}

