/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.actions.CreateNewEnumConstantDialog;
import com.intellij.uml.java.actions.NewJavaClassElement;
import com.intellij.util.PlatformIcons;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;

public class NewEnumConstant
extends NewJavaClassElement {
    public NewEnumConstant() {
        super("Enum constant", "Create new Enum constant", PlatformIcons.ENUM_ICON);
    }

    @Override
    public DiagramCategory getCategory() {
        return JavaUmlCategoryManager.FIELDS;
    }

    @Override
    public Runnable createWriteAction(final PsiClass psiClass, final DiagramBuilder builder) throws Exception {
        final CreateNewEnumConstantDialog dialog = new CreateNewEnumConstantDialog(psiClass);
        JComponent view = builder.getView().getCanvasComponent();
        Point vP = view.getLocationOnScreen();
        Dimension dSize = dialog.getPreferredSize();
        Dimension vSize = view.getSize();
        Point p = new Point(vP.x + (vSize.height - dSize.height) / 2, vP.y + (vSize.width - dSize.width) / 2);
        dialog.setLocation(p);
        if (dialog.showAndGet()) {
            return new Runnable(){

                @Override
                public void run() {
                    Project project = builder.getProject();
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    try {
                        String[] names;
                        for (String name : names = dialog.getNames()) {
                            if ((name = name.trim()).length() == 0) continue;
                            try {
                                PsiEnumConstant enumConstant = factory.createEnumConstantFromText(name, (PsiElement)psiClass);
                                PsiField[] fields = psiClass.getFields();
                                psiClass.addAfter((PsiElement)enumConstant, (PsiElement)(fields.length == 0 ? psiClass.getLBrace() : fields[fields.length - 1]));
                                new OptimizeImportsProcessor((AbstractLayoutCodeProcessor)new ReformatCodeProcessor(project, psiClass.getContainingFile(), null, false)).run();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        return null;
    }

    @Override
    public boolean isEnabledOn(PsiElement element) {
        return super.isEnabledOn(element) && ((PsiClass)element).isEnum();
    }

    public String getActionName() {
        return "New Enum Constant";
    }
}

