/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.project.DependencyPath;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlCategoryManager;
import com.intellij.uml.project.ModulesUmlDataModel;
import com.intellij.uml.project.ModulesUmlNode;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleNodeIntentionActionBase
extends DiagramNodeIntentionAction<ModuleItem> {
    public ModuleNodeIntentionActionBase(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    public boolean isAvailable(DiagramNode<ModuleItem> node) {
        return ((ModuleItem)node.getIdentifyingElement()).isModule();
    }

    public boolean isEnabled(AnActionEvent e, DiagramBuilder b) {
        return ModuleNodeIntentionActionBase.getSelectedModuleNode(e) != null;
    }

    protected void showPaths(final DiagramBuilder builder, Collection<List<Module>> paths) {
        final ArrayList<DependencyPath> dependencyPaths = new ArrayList<DependencyPath>();
        for (List<Module> path : paths) {
            dependencyPaths.add(new DependencyPath(path.toArray(new Module[path.size()])));
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ModulesUmlDataModel model = (ModulesUmlDataModel)builder.getDataModel();
                for (DiagramNode<ModuleItem> moduleNode : new ArrayList<DiagramNode<ModuleItem>>(model.getNodes())) {
                    DeleteSelectionWrapper.deleteNode(moduleNode, model);
                }
                for (DependencyPath path : dependencyPaths) {
                    for (Module module : path.getPaths()) {
                        model.addElement(new ModuleItem(module));
                    }
                }
                model.refreshDataModel(dependencyPaths);
            }
        };
        DiagramAction.performCommand((DiagramBuilder)builder, (Runnable)command, (String)this.getActionName(), null, (PsiElement[])new PsiElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Graph<Module> buildModulesGraph(DiagramBuilder builder, Project project) {
        Graph moduleGraph;
        AccessToken token = ReadAction.start();
        try {
            boolean includeTests = builder.getPresentation().isCategoryEnabled(ModulesUmlCategoryManager.TEST);
            moduleGraph = GraphAlgorithms.getInstance().invertEdgeDirections(ModuleManager.getInstance((Project)project).moduleGraph(includeTests));
        }
        finally {
            token.finish();
        }
        return moduleGraph;
    }

    @Nullable
    private static ModulesUmlNode getSelectedModuleNode(AnActionEvent e) {
        DiagramNode node;
        Object element;
        List selectedNodes = ModuleNodeIntentionActionBase.getSelectedNodes((AnActionEvent)e);
        if (selectedNodes.size() == 1 && (element = (node = (DiagramNode)selectedNodes.get(0)).getIdentifyingElement()) instanceof ModuleItem && ((ModuleItem)element).isModule()) {
            return (ModulesUmlNode)node;
        }
        return null;
    }
}

