/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jsp;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.web.mvc.jam.SpringMVCJamModel;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringMvcElVariablesProvider
extends ElVariablesProvider {
    private static final ElVariablesProvider JSP_EL_VARIABLES_PROVIDER = new JspElVariablesProvider();

    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder holder, @NotNull ELElementProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/jsp/SpringMvcElVariablesProvider", "processImplicitVariables"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/web/mvc/jsp/SpringMvcElVariablesProvider", "processImplicitVariables"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/web/mvc/jsp/SpringMvcElVariablesProvider", "processImplicitVariables"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder);
        if (module == null) {
            return true;
        }
        boolean viaJsp = JSP_EL_VARIABLES_PROVIDER.processImplicitVariables(element, holder, processor);
        if (!viaJsp) {
            return false;
        }
        if (!SpringMvcElVariablesProvider.processModelAttributes(holder, processor, module)) {
            return false;
        }
        SpringMVCModel model = SpringMVCModel.getModel(element);
        if (model == null) {
            return true;
        }
        if (!SpringMvcElVariablesProvider.processVariables(holder, processor, model)) {
            return false;
        }
        return SpringMvcElVariablesProvider.processConfigurationVariables(holder, processor, module, model);
    }

    private static boolean processModelAttributes(ELExpressionHolder holder, ELElementProcessor processor, Module module) {
        SpringMVCJamModel jamModel = SpringMVCJamModel.getModel(module);
        Collection<SpringMVCModelAttribute> attributes = jamModel.getModelAttributes();
        for (SpringMVCModelAttribute attribute : attributes) {
            PsiAnnotationMemberValue value;
            PsiAnnotation annotation;
            String name;
            PsiType type = attribute.getType();
            if (type == null || (name = attribute.getName()) == null || (annotation = attribute.getAnnotation()) == null || processor.processVariable((PsiVariable)new SpringModelELVariable((PsiElement)holder, name, type, (PsiElement)((value = annotation.findAttributeValue("value")) != null ? value : annotation), "NESTED"))) continue;
            return false;
        }
        return true;
    }

    private static boolean processVariables(ELExpressionHolder holder, final ELElementProcessor elElementProcessor, SpringMVCModel model) {
        return model.processVariables((PsiElement)holder, new Processor<PsiVariable>(){

            public boolean process(PsiVariable variable) {
                return elElementProcessor.processVariable(variable);
            }
        });
    }

    private static boolean processConfigurationVariables(final ELExpressionHolder holder, final ELElementProcessor elElementProcessor, Module module, SpringMVCModel model) {
        PsiClass internalViewResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.view.InternalResourceViewResolver");
        if (internalViewResolver == null) {
            return false;
        }
        Processor<SpringBeanPointer> processor = new Processor<SpringBeanPointer>(){

            public boolean process(SpringBeanPointer pointer) {
                CommonSpringBean bean = pointer.getSpringBean();
                String contextAttributeName = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"requestContextAttribute");
                if (StringUtil.isEmpty((String)contextAttributeName)) {
                    return true;
                }
                PsiClassType type = JavaPsiFacade.getElementFactory((Project)holder.getProject()).createTypeByFQClassName("org.springframework.web.servlet.support.RequestContext");
                SpringModelELVariable variable = new SpringModelELVariable((PsiElement)holder, contextAttributeName, (PsiType)type, bean.getIdentifyingPsiElement(), "NESTED");
                return elElementProcessor.processVariable((PsiVariable)variable);
            }
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)internalViewResolver).withInheritors();
        for (SpringModel springModel : model.getAllModels()) {
            if (springModel.processByClass(searchParameters, (Processor)processor)) continue;
            return false;
        }
        return true;
    }
}

