/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeViewResolver
extends ViewResolver {
    private final List<ViewResolver> myViewResolvers;

    public CompositeViewResolver(List<ViewResolver> viewResolvers) {
        this.myViewResolvers = viewResolvers;
    }

    @Override
    public String getID() {
        return super.getID() + "[" + StringUtil.join(this.myViewResolvers, (Function)new Function<ViewResolver, String>(){

            public String fun(ViewResolver resolver) {
                return resolver.getID();
            }
        }, (String)"|") + "]";
    }

    @Override
    @Nullable
    public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
        for (ViewResolver resolver : this.myViewResolvers) {
            PsiElement psiElement = resolver.resolveView(viewName, springMVCModel);
            if (psiElement == null) continue;
            return psiElement;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement resolveFinalView(String viewName, SpringMVCModel springMVCModel) {
        for (ViewResolver resolver : this.myViewResolvers) {
            PsiElement psiElement = resolver.resolveFinalView(viewName, springMVCModel);
            if (psiElement == null) continue;
            return psiElement;
        }
        return null;
    }

    @Override
    public List<LookupElement> getAllViews(SpringMVCModel context) {
        ArrayList<LookupElement> allViews = new ArrayList<LookupElement>();
        for (ViewResolver resolver : this.myViewResolvers) {
            allViews.addAll(resolver.getAllViews(context));
        }
        return allViews;
    }

    @Override
    @Nullable
    public String bindToElement(PsiElement element) {
        throw new UnsupportedOperationException("not supported " + element);
    }

    @Override
    @NotNull
    public String handleElementRename(String newElementName) {
        throw new UnsupportedOperationException("not supported " + newElementName);
    }

    public String toString() {
        return "CompositeViewResolver{myViewResolvers=" + this.myViewResolvers.size() + '}';
    }
}

