/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.mvc.FreeMarkerConfigurer;
import com.intellij.spring.model.xml.mvc.FreeMarkerTemplateLoaderPath;
import com.intellij.spring.model.xml.mvc.VelocityConfigurer;
import com.intellij.spring.web.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.web.mvc.views.ResourceBundleViewResolverFactory;
import com.intellij.spring.web.mvc.views.TemplateViewResolverFactory;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.XmlViewResolverFactory;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewResolverFactory {
    public static final ExtensionPointName<ViewResolverFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.mvc.viewResolverFactory");
    private static final NotNullLazyValue<ViewResolverFactory[]> ourFactories = new NotNullLazyValue<ViewResolverFactory[]>(){

        @NotNull
        protected ViewResolverFactory[] compute() {
            Object[] factories = new ViewResolverFactory[]{new TemplateViewResolverFactory("org.springframework.web.servlet.view.velocity.VelocityViewResolver", "org.springframework.web.servlet.view.velocity.VelocityConfigurer", "resourceLoaderPath"){

                @Override
                @NotNull
                protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, UrlBasedViewResolver resolver) {
                    if (configurer instanceof VelocityConfigurer) {
                        VelocityConfigurer velocityConfigurer = (VelocityConfigurer)configurer;
                        String resourceLoaderPath = velocityConfigurer.getResourceLoaderPath().getStringValue();
                        UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver(StringUtil.defaultIfEmpty((String)resourceLoaderPath, (String)"/WEB-INF/"), "");
                        if (urlBasedViewResolver == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory$1$1", "handleCustomConfigurer"));
                        }
                        return urlBasedViewResolver;
                    }
                    ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
                    if (viewResolver == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory$1$1", "handleCustomConfigurer"));
                    }
                    return viewResolver;
                }
            }, new TemplateViewResolverFactory("org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver", "org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer", "templateLoaderPath"){

                @Override
                @NotNull
                protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, UrlBasedViewResolver resolver) {
                    FreeMarkerConfigurer freeMarkerConfigurer;
                    List<FreeMarkerTemplateLoaderPath> paths;
                    if (configurer instanceof FreeMarkerConfigurer && (paths = (freeMarkerConfigurer = (FreeMarkerConfigurer)configurer).getTemplateLoaderPaths()).size() == 1) {
                        FreeMarkerTemplateLoaderPath templateLoaderPath = paths.get(0);
                        String location = templateLoaderPath.getLocation().getStringValue();
                        UrlBasedViewResolver urlBasedViewResolver = new UrlBasedViewResolver(StringUtil.defaultIfEmpty((String)location, (String)"/WEB-INF/"), "");
                        if (urlBasedViewResolver == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory$1$2", "handleCustomConfigurer"));
                        }
                        return urlBasedViewResolver;
                    }
                    ViewResolver viewResolver = super.handleCustomConfigurer(configurer, resolver);
                    if (viewResolver == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory$1$2", "handleCustomConfigurer"));
                    }
                    return viewResolver;
                }
            }, new UrlBasedViewResolverFactory(), new BeanNameViewResolverFactory(), new XmlViewResolverFactory(), new ResourceBundleViewResolverFactory()};
            ViewResolverFactory[] viewResolverFactoryArray = (ViewResolverFactory[])ArrayUtil.mergeArrays((Object[])Extensions.getExtensions(EP_NAME), (Object[])factories);
            if (viewResolverFactoryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory$1", "compute"));
            }
            return viewResolverFactoryArray;
        }
    };

    @NotNull
    public Set<ViewResolver> createResolvers(CommonSpringBean bean, PsiClass beanClass, SpringModel model) {
        Set<ViewResolver> set = this.isMine(bean, beanClass) ? this.doCreate(bean, model) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewResolverFactory", "createResolvers"));
        }
        return set;
    }

    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        String baseClassName = this.getBeanClass();
        return baseClassName != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)baseClassName);
    }

    @Nullable
    protected abstract String getBeanClass();

    protected abstract Set<ViewResolver> doCreate(CommonSpringBean var1, SpringModel var2);

    public static ViewResolverFactory[] getAllFactories() {
        return (ViewResolverFactory[])ourFactories.getValue();
    }
}

