/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CCaseRollbackEnvironment
implements RollbackEnvironment {
    @NonNls
    private static final String FILE_NOT_IN_VOB_SIG = "element name not found";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_1 = "Processing dir";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_2 = "Loading ";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_3 = "End dir";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_4 = "Done loading";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_5 = "Log has been written";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_6 = ".";
    @NonNls
    private static final String UPDATE_SUCC_PREFIX_7 = "Making dir";
    private final Project project;
    private final TransparentVcs host;

    public CCaseRollbackEnvironment(Project project, TransparentVcs host) {
        this.project = project;
        this.host = host;
    }

    public String getRollbackOperationName() {
        return VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> errors, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "net/sourceforge/transparent/Checkin/CCaseRollbackEnvironment", "rollbackChanges"));
        }
        HashSet<FilePath> processedFiles = new HashSet<FilePath>();
        listener.determinate();
        this.rollbackRenamedFolders(changes, processedFiles, listener);
        this.rollbackNew(changes, processedFiles, listener);
        this.rollbackDeleted(changes, processedFiles, errors, listener);
        this.rollbackChanged(changes, processedFiles, errors, listener);
        VcsUtil.refreshFiles((Project)this.project, processedFiles);
    }

    private void rollbackRenamedFolders(List<Change> changes, HashSet<FilePath> processedFiles, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "net/sourceforge/transparent/Checkin/CCaseRollbackEnvironment", "rollbackRenamedFolders"));
        }
        for (Change change : changes) {
            if (!VcsUtil.isRenameChange((Change)change) || !VcsUtil.isChangeForFolder((Change)change)) continue;
            listener.accept(change);
            FilePath newFolderPath = change.getAfterRevision().getFile();
            File folderNew = newFolderPath.getIOFile();
            FilePath oldFolderPath = change.getBeforeRevision().getFile();
            File folderOld = oldFolderPath.getIOFile();
            folderNew.renameTo(folderOld);
            this.host.renamedFolders.remove(VcsUtil.getCanonicalLocalPath((String)folderNew.getPath()));
            processedFiles.add(oldFolderPath);
            VcsUtil.waitForTheFile((String)folderOld.getPath());
        }
    }

    private void rollbackNew(List<Change> changes, HashSet<FilePath> processedFiles, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "net/sourceforge/transparent/Checkin/CCaseRollbackEnvironment", "rollbackNew"));
        }
        HashSet<FilePath> filesAndFolder = new HashSet<FilePath>();
        this.collectNewChangesBack(changes, filesAndFolder, processedFiles);
        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)this.project);
        for (FilePath file : filesAndFolder) {
            listener.accept(file);
            this.host.deleteNewFile(file.getVirtualFile());
            mgr.fileDirty(file);
        }
    }

    private void collectNewChangesBack(List<Change> changes, HashSet<FilePath> newFilesAndfolders, HashSet<FilePath> processedFiles) {
        HashSet<FilePath> foldersNew = new HashSet<FilePath>();
        for (Change change : changes) {
            if (!VcsUtil.isChangeForNew((Change)change)) continue;
            FilePath filePath = change.getAfterRevision().getFile();
            if (!filePath.isDirectory()) {
                newFilesAndfolders.add(filePath);
            } else {
                foldersNew.add(filePath);
            }
            processedFiles.add(filePath);
        }
        ChangeListManager clMgr = ChangeListManager.getInstance((Project)this.project);
        FileStatusManager fsMgr = FileStatusManager.getInstance((Project)this.project);
        List allAffectedFiles = clMgr.getAffectedFiles();
        for (VirtualFile file : allAffectedFiles) {
            FileStatus status = fsMgr.getStatus(file);
            if (status != FileStatus.ADDED) continue;
            for (FilePath folder : foldersNew) {
                if (!file.getPath().toLowerCase().startsWith(folder.getPath().toLowerCase())) continue;
                FilePath path = clMgr.getChange(file).getAfterRevision().getFile();
                newFilesAndfolders.add(path);
            }
        }
        newFilesAndfolders.addAll(foldersNew);
    }

    private void rollbackDeleted(List<Change> changes, HashSet<FilePath> processedFiles, List<VcsException> errors, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "net/sourceforge/transparent/Checkin/CCaseRollbackEnvironment", "rollbackDeleted"));
        }
        for (Change change : changes) {
            if (!VcsUtil.isChangeForDeleted((Change)change)) continue;
            listener.accept(change);
            FilePath filePath = change.getBeforeRevision().getFile();
            this.rollbackMissingFileDeletion(filePath, errors);
            processedFiles.add(filePath);
        }
    }

    private void rollbackChanged(List<Change> changes, HashSet<FilePath> processedFiles, List<VcsException> errors, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "net/sourceforge/transparent/Checkin/CCaseRollbackEnvironment", "rollbackChanged"));
        }
        for (Change change : changes) {
            File wasFile;
            Status status;
            if (VcsUtil.isChangeForNew((Change)change) || VcsUtil.isChangeForDeleted((Change)change)) continue;
            boolean isRenameChange = VcsUtil.isRenameChange((Change)change);
            if (VcsUtil.isChangeForFolder((Change)change) && isRenameChange && !Status.CHECKED_OUT.equals(status = this.host.getStatus(wasFile = change.getBeforeRevision().getFile().getIOFile())) && !Status.HIJACKED.equals(status)) continue;
            FilePath filePath = change.getAfterRevision().getFile();
            String path = filePath.getPath();
            listener.accept(change);
            if (isRenameChange) {
                ArrayList<VcsException> localErrors = new ArrayList<VcsException>();
                FilePath oldFile = change.getBeforeRevision().getFile();
                this.host.undoCheckoutFile(oldFile.getIOFile(), localErrors);
                if (localErrors.size() > 0 && !CCaseRollbackEnvironment.isUnknownFileError(localErrors)) {
                    errors.addAll(localErrors);
                }
                this.host.renamedFiles.remove(filePath.getPath());
                FileUtil.delete((File)new File(path));
            } else {
                Status fileStatus = this.host.getStatusSafely(filePath.getIOFile());
                if (!Status.HIJACKED.equals(fileStatus)) {
                    if (filePath.getVirtualFile() == null) {
                        this.host.undoCheckoutFile(filePath.getIOFile(), errors);
                    } else {
                        this.host.undoCheckoutFile(filePath.getVirtualFile(), errors);
                    }
                } else {
                    CCaseRollbackEnvironment.updateFile(path, errors);
                }
            }
            processedFiles.add(filePath);
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> paths, List<VcsException> exceptions, RollbackProgressListener listener) {
        for (FilePath path : paths) {
            listener.accept(path);
            this.rollbackMissingFileDeletion(path, exceptions);
        }
    }

    private void rollbackMissingFileDeletion(FilePath path, List<VcsException> errors) {
        VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)this.project);
        String normPath = VcsUtil.getCanonicalLocalPath((String)path.getPath());
        if (this.host.isFolderRemoved(normPath) || this.host.isFolderRemovedForVcs(normPath)) {
            CCaseRollbackEnvironment.updateFile(path.getPath(), errors);
            if (path.getIOFile().exists()) {
                this.undocheckoutInFolder(path.getPath(), errors);
            } else {
                this.host.removeFolderFromDeleted(normPath);
            }
        } else {
            ArrayList<VcsException> localErrors = new ArrayList<VcsException>();
            this.host.undoCheckoutFile(path.getIOFile(), localErrors);
            if (localErrors.size() > 0) {
                CCaseRollbackEnvironment.updateFile(path.getPath(), errors);
            }
        }
        mgr.fileDirty(path);
    }

    private void undocheckoutInFolder(String path, List<VcsException> errors) {
        String[] lines;
        String output = TransparentVcs.cleartoolOnLocalPathWithOutput(path, "lsch", "-short", "-r");
        TransparentVcs.LOG.info(output);
        for (String line : lines = LineTokenizer.tokenize((CharSequence)output, (boolean)false)) {
            File file = new File(path, line);
            this.host.undoCheckoutFile(file, errors);
        }
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> errors, RollbackProgressListener listener) {
        for (VirtualFile file : files) {
            listener.accept(file);
            CCaseRollbackEnvironment.updateFile(file.getPath(), errors);
            file.refresh(true, true);
        }
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private static void updateFile(String path, List<VcsException> errors) {
        try {
            String err = TransparentVcs.cleartoolWithOutput("update", "-overwrite", "-force", path);
            if (err != null) {
                String[] lines;
                for (String line : lines = LineTokenizer.tokenize((CharSequence)err, (boolean)false)) {
                    if (CCaseRollbackEnvironment.lineStartsWithKnownPrefix(line)) continue;
                    VcsException e = new VcsException(line);
                    e.setIsWarning(true);
                    errors.add(e);
                }
            }
        }
        catch (ClearCaseException e) {
            errors.add(new VcsException((Throwable)e));
        }
    }

    private static boolean isUnknownFileError(List<VcsException> errors) {
        for (VcsException exc : errors) {
            if (exc.getMessage().toLowerCase().indexOf(FILE_NOT_IN_VOB_SIG) == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean lineStartsWithKnownPrefix(String line) {
        return line.startsWith(UPDATE_SUCC_PREFIX_1) || line.startsWith(UPDATE_SUCC_PREFIX_2) || line.startsWith(UPDATE_SUCC_PREFIX_3) || line.startsWith(UPDATE_SUCC_PREFIX_4) || line.startsWith(UPDATE_SUCC_PREFIX_5) || line.startsWith(UPDATE_SUCC_PREFIX_6) || line.startsWith(UPDATE_SUCC_PREFIX_7);
    }
}

