/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StatusMultipleProcessor {
    @NonNls
    private static final String STATUS_COMMAND = "ls";
    @NonNls
    private static final String DIR_SWITCH = "-directory";
    @NonNls
    private static final String RECURSE_SWITCH = "-recurse";
    @NonNls
    private static final String VIEW_ONLY = "-view_only";
    @NonNls
    private static final String VERSIONED_SIG = "@@";
    @NonNls
    private static final String HIJACKED_SIG = "[hijacked]";
    @NonNls
    private static final String CHECKEDOUT_SIG = "Rule: CHECKEDOUT";
    @NonNls
    private static final String LOCALLY_DELETED = "[loaded but missing]";
    @NonNls
    private static final String CHECKEDOUT_REMOVED_SIG = "checkedout but removed";
    @NonNls
    private static final String WARNING_TO_SKIP_SIG = "Warning: ";
    private static final int CMDLINE_MAX_LENGTH = 512;
    private final String[] files;
    private boolean myRecursive;
    private boolean myViewOnly;
    private HashSet<String> locallyDeleted;
    private HashSet<String> deletedFiles;
    private HashSet<String> nonexistingFiles;
    private HashSet<String> checkoutFiles;
    private HashSet<String> hijackedFiles;

    public StatusMultipleProcessor(List<String> paths) {
        this.files = ArrayUtil.toStringArray(paths);
    }

    public HashSet<String> getLocallyDeleted() {
        return this.locallyDeleted;
    }

    public HashSet<String> getUnversioned() {
        return this.nonexistingFiles;
    }

    public HashSet<String> getCheckoutFiles() {
        return this.checkoutFiles;
    }

    public HashSet<String> getHijackedFiles() {
        return this.hijackedFiles;
    }

    @Nullable
    public static String getCurrentRevision(String path) {
        String out = TransparentVcs.cleartoolWithOutput(STATUS_COMMAND, DIR_SWITCH, path);
        if (out.contains(WARNING_TO_SKIP_SIG)) {
            return null;
        }
        int idxVer = out.indexOf(VERSIONED_SIG);
        if (idxVer == -1) {
            return null;
        }
        return new String(out.substring(idxVer, out.indexOf(32, idxVer)));
    }

    public void execute() {
        this.deletedFiles = new HashSet();
        this.nonexistingFiles = new HashSet();
        this.checkoutFiles = new HashSet();
        this.hijackedFiles = new HashSet();
        this.locallyDeleted = new HashSet();
        int currFileIndex = 0;
        int batchStartIndex = 0;
        LinkedList<String> options = new LinkedList<String>();
        while (currFileIndex < this.files.length) {
            int cmdLineLen = 0;
            options.clear();
            options.add(STATUS_COMMAND);
            cmdLineLen += STATUS_COMMAND.length() + 1;
            if (this.myRecursive) {
                options.add(RECURSE_SWITCH);
                cmdLineLen += RECURSE_SWITCH.length() + 1;
            } else {
                options.add(DIR_SWITCH);
                cmdLineLen += DIR_SWITCH.length() + 1;
            }
            if (this.myViewOnly) {
                options.add(VIEW_ONLY);
                cmdLineLen += VIEW_ONLY.length() + 1;
            }
            while (currFileIndex < this.files.length && cmdLineLen < 512) {
                String path = this.files[currFileIndex++];
                options.add(path);
                cmdLineLen += path.length() + 1;
            }
            String[] aOptions = ArrayUtil.toStringArray(options);
            String out = TransparentVcs.cleartoolWithOutput(aOptions);
            try {
                this.parseCleartoolOutput(out, batchStartIndex);
            }
            catch (Exception e) {
                TransparentVcs.LOG.info("Failed to parse LS output (possible unknown message format):");
                TransparentVcs.LOG.info(out);
                throw new ClearCaseException("Failed to parse LS output (possible unknown message format):" + e.getMessage());
            }
            batchStartIndex = currFileIndex;
        }
    }

    private void parseCleartoolOutput(String out, int startIndex) {
        String[] lines;
        int shiftIndex = 0;
        for (String line : lines = LineTokenizer.tokenize((CharSequence)out, (boolean)false)) {
            if (line.indexOf(WARNING_TO_SKIP_SIG) != -1) continue;
            int versIdx = line.indexOf(VERSIONED_SIG);
            if (versIdx == -1) {
                this.nonexistingFiles.add(line.replace('\\', '/'));
            } else if (line.indexOf(CHECKEDOUT_SIG) != -1) {
                this.checkoutFiles.add(this.filePathFromLine(line, versIdx));
            } else if (line.indexOf(LOCALLY_DELETED) != -1 || line.indexOf(CHECKEDOUT_REMOVED_SIG) != -1) {
                this.locallyDeleted.add(this.filePathFromLine(line, versIdx));
            } else if (line.indexOf(HIJACKED_SIG) != -1) {
                this.hijackedFiles.add(this.filePathFromLine(line, versIdx));
            }
            ++shiftIndex;
        }
    }

    private String filePathFromLine(String line, int versIdx) {
        return line.substring(0, versIdx).replace('\\', '/');
    }

    public void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    public void setViewOnly(boolean viewOnly) {
        this.myViewOnly = viewOnly;
    }
}

