/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.SynchronousAction;
import org.jetbrains.annotations.NonNls;

public class UndoCheckOutAction
extends SynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Undo Checkout";

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        return file.isDirectory() || UndoCheckOutAction.properStatus(project, file);
    }

    @Override
    protected void perform(VirtualFile file, Project project) throws VcsException {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        if (!file.isDirectory() && UndoCheckOutAction.properStatus(project, file)) {
            TransparentVcs.getInstance(project).undoCheckoutFile(file, errors);
            file.refresh(true, false);
        }
        if (errors.size() > 0) {
            throw (VcsException)((Object)errors.get(0));
        }
    }

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    private static boolean properStatus(Project project, VirtualFile file) {
        FileStatus status = UndoCheckOutAction.getFileStatus(project, file);
        return status == FileStatus.MODIFIED || status == FileStatus.MERGED_WITH_CONFLICTS;
    }
}

