/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringComponentScanModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleSpringModel
extends CachedLocalModel {
    @Override
    @NotNull
    public Collection<SpringBeanPointer> calculateDomBeans() {
        com.intellij.util.containers.hash.HashSet domPointers = new com.intellij.util.containers.hash.HashSet();
        for (SpringBeanPointer pointer : this.getAllCommonBeans()) {
            if (pointer instanceof JamSpringBeanPointer) continue;
            domPointers.add(pointer);
        }
        Set<SpringBeanPointer> set = Collections.unmodifiableSet(domPointers);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "calculateDomBeans"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getAllBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
        }
        SpringBeanPointer beanPointer = SpringModelSearchers.findBean(this, beanName);
        if (beanPointer == null) {
            Set<String> set = Collections.singleton(beanName);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
            }
            return set;
        }
        String[] aliases = beanPointer.getAliases();
        if (aliases.length == 0) {
            Set<String> set = Collections.singleton(beanName);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
            }
            return set;
        }
        HashSet<String> allBeanNames = new HashSet<String>(aliases.length + 1);
        allBeanNames.add(beanName);
        for (String aliasName : aliases) {
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            allBeanNames.add(aliasName);
        }
        HashSet<String> hashSet = allBeanNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAllBeanNames"));
        }
        return hashSet;
    }

    @Override
    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getDuplicatedNames"));
        }
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        List<SpringBeanPointer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPlaceholderConfigurers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        List<SpringBeansPackagesScan> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getComponentScans"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        List<SpringBeanPointer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getAnnotationConfigApplicationContexts"));
        }
        return list;
    }

    @Override
    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getDescendants"));
        }
        List<SpringBeanPointer> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getDescendants"));
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getActiveProfiles"));
        }
        return set;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByClass"));
        }
        if (!params.canSearch()) {
            return true;
        }
        PsiClass searchClass = params.getSearchClass();
        boolean withInheritors = params.isWithInheritors();
        if (params.isEffectiveBeanTypes()) {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                for (PsiClass effectiveBeanType : beanPointer.getEffectiveBeanType()) {
                    if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchClass, beanPointer, effectiveBeanType, withInheritors)) continue;
                    return false;
                }
            }
        } else {
            for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
                if (AbstractSimpleSpringModel.processLocalBeanClass(processor, searchClass, beanPointer, beanPointer.getBeanClass(), withInheritors)) continue;
                return false;
            }
        }
        return super.processByClass(params, processor);
    }

    private static boolean processLocalBeanClass(@NotNull Processor<SpringBeanPointer> processor, @NotNull PsiClass searchClass, SpringBeanPointer beanPointer, @Nullable PsiClass beanClass, boolean withInheritors) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeanClass"));
        }
        if (searchClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchClass", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processLocalBeanClass"));
        }
        if (beanClass != null && (beanClass.getManager().areElementsEquivalent((PsiElement)searchClass, (PsiElement)beanClass) || withInheritors && beanClass.isInheritor(searchClass, true))) {
            return processor.process((Object)beanPointer);
        }
        return true;
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "processByName"));
        }
        if (!params.canSearch()) {
            return true;
        }
        for (SpringBeanPointer beanPointer : this.getLocalBeans()) {
            if (!AbstractSimpleSpringModel.matchesName(params, beanPointer) || processor.process((Object)beanPointer)) continue;
            return false;
        }
        return super.processByName(params, processor);
    }

    private static boolean matchesName(SpringModelSearchParameters.BeanName params, SpringBeanPointer pointer) {
        String paramsBeanName = params.getBeanName();
        if (paramsBeanName.equals(pointer.getName())) {
            return true;
        }
        for (String aliasName : pointer.getAliases()) {
            if (!paramsBeanName.equals(aliasName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Set<CommonSpringModel> getPackageScanModels(@NotNull Set<? extends LocalModel> localModels, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (localModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localModels", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        for (LocalModel localModel : localModels) {
            List<SpringBeansPackagesScan> scans = localModel.getComponentScans();
            for (SpringBeansPackagesScan scan : scans) {
                models.add(new SpringComponentScanModel<SpringBeansPackagesScan>(module, scan, activeProfiles));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AbstractSimpleSpringModel", "getPackageScanModels"));
        }
        return linkedHashSet;
    }
}

