/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.VisitedModelsDelegateProcessor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.custom.CustomComponentsDiscovererHelper;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModel
implements CommonSpringModel {
    @Nullable
    private final Module myModule;
    private Set<SpringModel> myDependencies = Collections.emptySet();
    @Nullable
    private final SpringFileSet myFileSet;
    public static final CommonSpringModel UNKNOWN = new CommonSpringModel(){

        @Override
        public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel$16", "processByClass"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel$16", "processByClass"));
            }
            return true;
        }

        @Override
        public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel$16", "processByName"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel$16", "processByName"));
            }
            return true;
        }

        @Override
        @NotNull
        public Collection<SpringBeanPointer> getAllDomBeans() {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getAllDomBeans"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<SpringBeanPointer> getAllCommonBeans() {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getAllCommonBeans"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<String> getAllBeanNames(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel$16", "getAllBeanNames"));
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getAllBeanNames"));
            }
            return set;
        }

        @Override
        public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel$16", "getDuplicatedNames"));
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> getPlaceholderConfigurers() {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getPlaceholderConfigurers"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<SpringBeansPackagesScan> getComponentScans() {
            List<SpringBeansPackagesScan> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getComponentScans"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getAnnotationConfigApplicationContexts"));
            }
            return list;
        }

        @Override
        public Collection<XmlTag> getCustomBeanCandidates(String id) {
            return Collections.emptyList();
        }

        @Override
        public Module getModule() {
            return null;
        }

        @Override
        public Set<String> getActiveProfiles() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<String> getAllProfiles() {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getAllProfiles"));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<PsiFile> getConfigFiles() {
            Set<PsiFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getConfigFiles"));
            }
            return set;
        }

        @Override
        public boolean hasConfigFile(@NotNull PsiFile configFile) {
            if (configFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/SpringModel$16", "hasConfigFile"));
            }
            return false;
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> findQualifiedBeans(@NotNull SpringQualifier qualifier) {
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/SpringModel$16", "findQualifiedBeans"));
            }
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "findQualifiedBeans"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/contexts/model/SpringModel$16", "getDescendants"));
            }
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel$16", "getDescendants"));
            }
            return list;
        }
    };

    protected SpringModel(@Nullable Module module) {
        this(module, null);
    }

    protected SpringModel(@Nullable Module module, @Nullable SpringFileSet fileSet) {
        this.myFileSet = fileSet;
        this.myModule = module;
    }

    public SpringFileSet getFileSet() {
        return this.myFileSet;
    }

    @NotNull
    public Set<SpringModel> getDependencies() {
        Set<SpringModel> set = this.myDependencies;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getDependencies"));
        }
        return set;
    }

    public void setDependencies(@NotNull Set<SpringModel> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/spring/contexts/model/SpringModel", "setDependencies"));
        }
        this.myDependencies = dependencies;
    }

    @NotNull
    public final Set<CommonSpringModel> getModelsToProcess() {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        ContainerUtil.addAllNotNull(models, this.getModelsToProcess(true));
        if (this.myModule != null && !this.myModule.isDisposed()) {
            ContainerUtil.addAllNotNull(models, CustomComponentsDiscovererHelper.getInstance(this.myModule).getCustomModels());
        }
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    public abstract Set<CommonSpringModel> getModelsToProcess(boolean var1);

    @Override
    @NotNull
    public Collection<SpringBeanPointer> getAllDomBeans() {
        final ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                pointers.addAll(model.getAllDomBeans());
                return true;
            }
        });
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllDomBeans"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<String> getAllBeanNames(final @NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "getAllBeanNames"));
        }
        THashSet allOtherNames = new THashSet();
        this.processModels(new Processor<CommonSpringModel>((Set)allOtherNames){
            final /* synthetic */ Set val$allOtherNames;
            {
                this.val$allOtherNames = set;
            }

            public boolean process(CommonSpringModel model) {
                Set<String> otherNames = model.getAllBeanNames(beanName);
                if (otherNames.size() > 1) {
                    this.val$allOtherNames.addAll(otherNames);
                }
                return true;
            }
        });
        Object object = allOtherNames.size() > 0 ? allOtherNames : Collections.singleton(beanName);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllBeanNames"));
        }
        return object;
    }

    @Override
    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/SpringModel", "getDuplicatedNames"));
        }
        SmartList pointers = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((List)pointers, beanName){
            final /* synthetic */ List val$pointers;
            final /* synthetic */ String val$beanName;
            {
                this.val$pointers = list;
                this.val$beanName = string;
            }

            public boolean process(CommonSpringModel model) {
                this.val$pointers.addAll(model.getDuplicatedNames(this.val$beanName));
                return true;
            }
        });
        return pointers;
    }

    @Override
    @NotNull
    public Collection<SpringBeanPointer> getAllCommonBeans() {
        final ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                pointers.addAll(model.getAllCommonBeans());
                return true;
            }
        });
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAllCommonBeans"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> findQualifiedBeans(final @NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/spring/contexts/model/SpringModel", "findQualifiedBeans"));
        }
        final ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                pointers.addAll(model.findQualifiedBeans(qualifier));
                return true;
            }
        });
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "findQualifiedBeans"));
        }
        return arrayList;
    }

    @Override
    public boolean processByClass(final @NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processByClass"));
        }
        if (!params.canSearch()) {
            return true;
        }
        final VisitedModelsDelegateProcessor delegateProcessor = new VisitedModelsDelegateProcessor(processor);
        return this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel commonModel) {
                if (delegateProcessor.hasBeenVisited(commonModel)) {
                    return true;
                }
                delegateProcessor.addVisited(commonModel);
                return commonModel.processByClass(params, delegateProcessor);
            }
        });
    }

    @Override
    public boolean processByName(final @NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/SpringModel", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processByName"));
        }
        if (!params.canSearch()) {
            return true;
        }
        final VisitedModelsDelegateProcessor delegateProcessor = new VisitedModelsDelegateProcessor(processor);
        return this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel commonModel) {
                if (delegateProcessor.hasBeenVisited(commonModel)) {
                    return true;
                }
                delegateProcessor.addVisited(commonModel);
                return commonModel.processByName(params, delegateProcessor);
            }
        });
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public String toString() {
        SpringFileSet fileSet = this.getFileSet();
        return this.getClass().getName() + (fileSet != null ? " fileset=" + fileSet.getId() : "");
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        SmartList pointers = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((List)pointers){
            final /* synthetic */ List val$pointers;
            {
                this.val$pointers = list;
            }

            public boolean process(CommonSpringModel model) {
                this.val$pointers.addAll(model.getPlaceholderConfigurers());
                return true;
            }
        });
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getPlaceholderConfigurers"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        SmartList pointers = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((List)pointers){
            final /* synthetic */ List val$pointers;
            {
                this.val$pointers = list;
            }

            public boolean process(CommonSpringModel model) {
                this.val$pointers.addAll(model.getComponentScans());
                return true;
            }
        });
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getComponentScans"));
        }
        return smartList;
    }

    protected boolean processModels(@NotNull Processor<CommonSpringModel> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        return SpringModel.processModels(this, (Set<CommonSpringModel>)new HashSet(), processor);
    }

    private static boolean processModels(@NotNull CommonSpringModel model, @NotNull Set<CommonSpringModel> visited, @NotNull Processor<CommonSpringModel> processor) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/SpringModel", "processModels"));
        }
        if (!visited.contains(model)) {
            visited.add(model);
            ProgressManager.checkCanceled();
            if (model instanceof SpringModel) {
                for (CommonSpringModel commonModel : ((SpringModel)model).getModelsToProcess()) {
                    if (SpringModel.processModels(commonModel, visited, processor)) continue;
                    return false;
                }
            } else {
                return processor.process((Object)model);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        SmartList pointers = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((List)pointers){
            final /* synthetic */ List val$pointers;
            {
                this.val$pointers = list;
            }

            public boolean process(CommonSpringModel model) {
                this.val$pointers.addAll(model.getAnnotationConfigApplicationContexts());
                return true;
            }
        });
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getAnnotationConfigApplicationContexts"));
        }
        return smartList;
    }

    @Override
    @Nullable
    public Set<String> getActiveProfiles() {
        if (this.myFileSet == null) {
            return null;
        }
        return this.myFileSet.getActiveProfiles();
    }

    @Override
    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        SmartList tags = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((Collection)tags, id){
            final /* synthetic */ Collection val$tags;
            final /* synthetic */ String val$id;
            {
                this.val$tags = collection;
                this.val$id = string;
            }

            public boolean process(CommonSpringModel model) {
                this.val$tags.addAll(model.getCustomBeanCandidates(this.val$id));
                return true;
            }
        });
        return tags;
    }

    @Override
    @NotNull
    public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/contexts/model/SpringModel", "getDescendants"));
        }
        SmartList pointers = new SmartList();
        this.processModels(new Processor<CommonSpringModel>((List)pointers, context){
            final /* synthetic */ List val$pointers;
            final /* synthetic */ SpringBeanPointer val$context;
            {
                this.val$pointers = list;
                this.val$context = springBeanPointer;
            }

            public boolean process(CommonSpringModel model) {
                this.val$pointers.addAll(model.getDescendants(this.val$context));
                return true;
            }
        });
        SmartList smartList = pointers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getDescendants"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public Set<PsiFile> getConfigFiles() {
        final LinkedHashSet<PsiFile> files = new LinkedHashSet<PsiFile>();
        Processor<CommonSpringModel> collectConfigFiles = new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel commonSpringModel) {
                files.addAll(commonSpringModel.getConfigFiles());
                return true;
            }
        };
        this.processConfigFiles(collectConfigFiles);
        LinkedHashSet<PsiFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringModel", "getConfigFiles"));
        }
        return linkedHashSet;
    }

    @Override
    public boolean hasConfigFile(final @NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/SpringModel", "hasConfigFile"));
        }
        CommonProcessors.FindProcessor<CommonSpringModel> findProcessor = new CommonProcessors.FindProcessor<CommonSpringModel>(){

            protected boolean accept(CommonSpringModel model) {
                return model.hasConfigFile(configFile);
            }
        };
        this.processConfigFiles((Processor<CommonSpringModel>)findProcessor);
        return findProcessor.isFound();
    }

    protected boolean processConfigFiles(final Processor<CommonSpringModel> collectConfigFiles) {
        return this.processModels(new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel commonModel) {
                if (!collectConfigFiles.process((Object)commonModel)) {
                    return false;
                }
                return !(commonModel instanceof CachedLocalModel) || ((CachedLocalModel)commonModel).processRelatedModels((Processor<CommonSpringModel>)collectConfigFiles);
            }
        });
    }
}

