/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpringModelSearchParameters {
    protected SpringModelSearchParameters() {
    }

    public abstract boolean canSearch();

    public static BeanClass byClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringModelSearchParameters", "byClass"));
        }
        return new BeanClass(psiClass);
    }

    public static BeanName byName(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringModelSearchParameters", "byName"));
        }
        return new BeanName(beanName);
    }

    public static class BeanName
    extends SpringModelSearchParameters {
        @NotNull
        private final String myBeanName;
        private final boolean myCanSearch;

        private BeanName(@NotNull String beanName) {
            if (beanName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringModelSearchParameters$BeanName", "<init>"));
            }
            this.myBeanName = beanName;
            this.myCanSearch = StringUtil.isNotEmpty((String)beanName);
        }

        @Override
        public boolean canSearch() {
            return this.myCanSearch;
        }

        @NotNull
        public String getBeanName() {
            String string = this.myBeanName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringModelSearchParameters$BeanName", "getBeanName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanName)) {
                return false;
            }
            BeanName name = (BeanName)o;
            if (this.myCanSearch != name.myCanSearch) {
                return false;
            }
            return this.myBeanName.equals(name.myBeanName);
        }

        public int hashCode() {
            return this.myBeanName.hashCode();
        }
    }

    public static class BeanClass
    extends SpringModelSearchParameters {
        private final PsiClass myPsiClass;
        private final boolean myCanSearch;
        private boolean myWithInheritors;
        private boolean myEffectiveBeanTypes;

        private BeanClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringModelSearchParameters$BeanClass", "<init>"));
            }
            this.myPsiClass = psiClass;
            this.myCanSearch = SpringCommonUtils.isSpringBeanCandidateClass(psiClass);
        }

        @Override
        public boolean canSearch() {
            return this.myCanSearch;
        }

        public BeanClass withInheritors() {
            this.myWithInheritors = true;
            return this;
        }

        @Deprecated
        public BeanClass withInheritors(GlobalSearchScope inheritorsSearchScope) {
            return this.withInheritors();
        }

        public BeanClass effectiveBeanTypes() {
            this.myEffectiveBeanTypes = true;
            return this;
        }

        @NotNull
        public PsiClass getSearchClass() {
            PsiClass psiClass = this.myPsiClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringModelSearchParameters$BeanClass", "getSearchClass"));
            }
            return psiClass;
        }

        public boolean isWithInheritors() {
            return this.myWithInheritors;
        }

        public boolean isEffectiveBeanTypes() {
            return this.myEffectiveBeanTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanClass)) {
                return false;
            }
            BeanClass beanClass = (BeanClass)o;
            if (this.myEffectiveBeanTypes != beanClass.myEffectiveBeanTypes) {
                return false;
            }
            if (this.myWithInheritors != beanClass.myWithInheritors) {
                return false;
            }
            if (this.myCanSearch != beanClass.myCanSearch) {
                return false;
            }
            return this.myPsiClass.equals(beanClass.getSearchClass());
        }

        public int hashCode() {
            int result = this.myPsiClass.hashCode();
            result = 31 * result + (this.myWithInheritors ? 1 : 0);
            result = 31 * result + (this.myEffectiveBeanTypes ? 1 : 0);
            return result;
        }
    }
}

