/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResolveConverter
extends ResolvingConverter<SpringBeanPointer>
implements CustomReferenceConverter {
    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(SpringBeanPointer.class, elementClass);
    }

    @Nullable
    protected CommonSpringModel getSpringModel(ConvertContext context) {
        return SpringManager.getInstance(context.getFile().getProject()).getSpringModelByFile((PsiFile)context.getFile());
    }

    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        List<PsiClassType> list = SpringConverterUtil.getRequiredBeanTypeClasses(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getRequiredClasses"));
        }
        return list;
    }

    @Nullable
    public SpringBeanPointer fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        CommonSpringModel springModel = this.getSpringModel(context);
        if (springModel == null) {
            return null;
        }
        return SpringBeanUtils.getInstance().findBean(springModel, s);
    }

    public String toString(@Nullable SpringBeanPointer springBeanPointer, ConvertContext context) {
        return springBeanPointer == null ? null : springBeanPointer.getName();
    }

    public LookupElement createLookupElement(SpringBeanPointer springBeanPointer) {
        return SpringConverterUtil.createCompletionVariant(springBeanPointer);
    }

    public PsiElement getPsiElement(@Nullable SpringBeanPointer resolvedValue) {
        if (resolvedValue == null || !resolvedValue.isValid()) {
            return null;
        }
        return resolvedValue.getPsiElement();
    }

    public String getErrorMessage(String s, ConvertContext context) {
        return SpringApiBundle.message("model.bean.error.message", s);
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(value), (Object)new GenericDomValueReference(value));
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        return SpringBeanResolveQuickFixManager.getInstance().getQuickFixes(context, (Beans)element.getParentOfType(Beans.class, false), null, this.getRequiredClasses(context));
    }

    @NotNull
    public Collection<SpringBeanPointer> getVariants(ConvertContext context) {
        if (SpringBeanResolveConverter.isPlaceholder(context)) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getVariants"));
            }
            return set;
        }
        Collection<SpringBeanPointer> collection = SpringBeanResolveConverter.getVariants(context, false, false, this.getRequiredClasses(context), this.getSpringModel(context));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getVariants"));
        }
        return collection;
    }

    protected static boolean isPlaceholder(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        return element instanceof GenericDomValue && PlaceholderUtils.getInstance().isRawTextPlaceholder((GenericDomValue)element);
    }

    protected static Collection<SpringBeanPointer> getVariants(ConvertContext context, boolean parentBeans, boolean allowAbstracts, List<PsiClassType> requiredClasses, CommonSpringModel model) {
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<SpringBeanPointer> variants = new ArrayList<SpringBeanPointer>();
        CommonSpringBean currentBean = SpringConverterUtil.getCurrentBeanCustomAware(context);
        if (!requiredClasses.isEmpty()) {
            PsiClassType object = PsiType.getJavaLangObject((PsiManager)context.getPsiManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
            requiredClasses.remove(object);
        }
        Collection<SpringBeanPointer> pointers = SpringBeanResolveConverter.getModelVariants(parentBeans, model, requiredClasses, currentBean);
        SpringConverterUtil.processBeans(model, variants, pointers, allowAbstracts, currentBean);
        return variants;
    }

    private static Collection<SpringBeanPointer> getModelVariants(boolean parentBeans, CommonSpringModel model, @NotNull List<PsiClassType> requiredClasses, CommonSpringBean currentBean) {
        if (requiredClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredClasses", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getModelVariants"));
        }
        if (parentBeans) {
            if (model instanceof XmlSpringModel) {
                ArrayList<SpringBeanPointer> allBeans = new ArrayList<SpringBeanPointer>();
                for (SpringModel springModel : ((XmlSpringModel)model).getDependencies()) {
                    if (requiredClasses.isEmpty()) {
                        allBeans.addAll(springModel.getAllCommonBeans());
                        continue;
                    }
                    allBeans.addAll(SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model));
                }
                return allBeans;
            }
            return Collections.emptySet();
        }
        return requiredClasses.isEmpty() ? model.getAllCommonBeans() : SpringConverterUtil.getSmartVariants(currentBean, requiredClasses, model);
    }

    @NotNull
    protected static List<PsiClassType> getValueClasses(ConvertContext context) {
        TypeHolder valueHolder = (TypeHolder)context.getInvocationElement().getParentOfType(TypeHolder.class, false);
        if (valueHolder == null) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getValueClasses"));
            }
            return list;
        }
        List list = ContainerUtil.findAll(TypeHolderUtil.getRequiredTypes(valueHolder), PsiClassType.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter", "getValueClasses"));
        }
        return list;
    }

    public static class Parent
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public Collection<SpringBeanPointer> getVariants(ConvertContext context) {
            Collection<SpringBeanPointer> collection = Parent.getVariants(context, false, true, this.getRequiredClasses(context), this.getSpringModel(context));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter$Parent", "getVariants"));
            }
            return collection;
        }
    }

    public static class PropertyBean
    extends SpringBeanResolveConverter {
        @Override
        @NotNull
        public List<PsiClassType> getRequiredClasses(ConvertContext context) {
            List<PsiClassType> list = PropertyBean.getValueClasses(context);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanResolveConverter$PropertyBean", "getRequiredClasses"));
            }
            return list;
        }
    }
}

