/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class SpringImportResourceConverter
extends Converter<Set<PsiFile>>
implements CustomReferenceConverter {
    private static final NullableFunction<ResolveResult, XmlFile> XML_FILE_MAPPER = new NullableFunction<ResolveResult, XmlFile>(){

        public XmlFile fun(ResolveResult result) {
            PsiElement psiElement = result.getElement();
            return psiElement instanceof XmlFile ? (XmlFile)psiElement : null;
        }
    };

    public static List<XmlFile> getFiles(PsiReference[] references) {
        for (PsiReference reference : references) {
            FileReference lastFileReference;
            FileReference fileReference = FileReference.findFileReference((PsiReference)reference);
            if (fileReference == null || (lastFileReference = fileReference.getLastFileReference()) == null) continue;
            Object[] resolve = lastFileReference.multiResolve(false);
            return ContainerUtil.mapNotNull((Object[])resolve, XML_FILE_MAPPER);
        }
        return Collections.emptyList();
    }
}

