/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringCacheUtils {
    public static Set<CommonSpringBean> getCreatedCachedBeans(final @NotNull Module module, @NotNull CommonModelElement creationElement, final @NotNull Function<Module, Set<CommonSpringBean>> function) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/utils/SpringCacheUtils", "getCreatedCachedBeans"));
        }
        if (creationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creationElement", "com/intellij/spring/model/utils/SpringCacheUtils", "getCreatedCachedBeans"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/spring/model/utils/SpringCacheUtils", "getCreatedCachedBeans"));
        }
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        PsiElement identifyingPsiElement = creationElement.getIdentifyingPsiElement();
        if (identifyingPsiElement == null || !identifyingPsiElement.isValid()) {
            return Collections.emptySet();
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)identifyingPsiElement, (CachedValueProvider)new CachedValueProvider<Map<Module, Set<CommonSpringBean>>>(){

            public CachedValueProvider.Result<Map<Module, Set<CommonSpringBean>>> compute() {
                ConcurrentFactoryMap<Module, Set<CommonSpringBean>> map = new ConcurrentFactoryMap<Module, Set<CommonSpringBean>>(){

                    protected Set<CommonSpringBean> create(Module key) {
                        return (Set)function.fun((Object)module);
                    }
                };
                Object[] dependencies = SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies();
                return CachedValueProvider.Result.create((Object)map, (Object[])dependencies);
            }
        });
        return (Set)map.get(module);
    }
}

