/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.ConvertContextFactory;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceValueConverter
extends Converter<Set<PsiFileSystemItem>>
implements CustomReferenceConverter {
    public Set<PsiFileSystemItem> fromString(@Nullable @NonNls String s, ConvertContext context) {
        GenericDomValue domValue = (GenericDomValue)context.getInvocationElement();
        if (StringUtil.isEmpty((String)s)) {
            return Collections.emptySet();
        }
        return ResourceValueConverter.addResourceFilesFrom(domValue, new THashSet(), this.getFilter(), this);
    }

    private static <V extends PsiFileSystemItem> Set<V> addResourceFilesFrom(@NotNull GenericDomValue element, Set<V> result, Condition<PsiFileSystemItem> filter, Converter converter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/converters/resources/ResourceValueConverter", "addResourceFilesFrom"));
        }
        if (converter instanceof CustomReferenceConverter) {
            PsiReference[] references = ((CustomReferenceConverter)converter).createReferences(element, (PsiElement)element.getXmlElement(), ConvertContextFactory.createConvertContext((DomElement)element));
            result.addAll(SpringResourcesUtil.getInstance().getResourceItems(references, filter));
            return result;
        }
        return result;
    }

    public String toString(@Nullable Set<PsiFileSystemItem> o, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, final PsiElement element, ConvertContext context) {
        final int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        final Condition<PsiFileSystemItem> filterCondition = this.getFilter(genericDomValue);
        final Function<PsiFile, Collection<PsiFileSystemItem>> customDefaultPathEvaluator = this.getCustomDefaultPathEvaluator(element);
        SmartList result = new SmartList();
        SpringReferenceUtils.processSeparatedString(genericDomValue.getStringValue(), ",", new PairProcessor<String, Integer>((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public boolean process(String s, Integer offset) {
                SpringResourcesBuilder builder = SpringResourcesBuilder.create(element, s).fromRoot(true).offset(offset + startInElement).filter((Condition<PsiFileSystemItem>)filterCondition).endingSlashNotAllowed(true).customDefaultPathEvaluator((Function<PsiFile, Collection<PsiFileSystemItem>>)customDefaultPathEvaluator);
                ContainerUtil.addAll((Collection)this.val$result, (Object[])SpringResourcesUtil.getInstance().getReferences(builder));
                return true;
            }
        });
        PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/resources/ResourceValueConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected Condition<PsiFileSystemItem> getFilter() {
        return Conditions.alwaysTrue();
    }

    @Nullable
    protected Function<PsiFile, Collection<PsiFileSystemItem>> getCustomDefaultPathEvaluator(PsiElement element) {
        return null;
    }

    @NotNull
    protected Condition<PsiFileSystemItem> getFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/values/converters/resources/ResourceValueConverter", "getFilter"));
        }
        for (SpringResourceTypeProvider provider : (SpringResourceTypeProvider[])Extensions.getExtensions(SpringResourceTypeProvider.EP_NAME)) {
            Condition<PsiFileSystemItem> filter = provider.getResourceFilter(genericDomValue);
            if (filter == null) continue;
            Condition<PsiFileSystemItem> condition = filter;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/resources/ResourceValueConverter", "getFilter"));
            }
            return condition;
        }
        Condition<PsiFileSystemItem> condition = this.getFilter();
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/resources/ResourceValueConverter", "getFilter"));
        }
        return condition;
    }

    public static class ResourceValueConverterCondition
    implements Condition<Pair<PsiType, GenericDomValue>> {
        public boolean value(Pair<PsiType, GenericDomValue> pair) {
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            String psiTypeText = psiType.getCanonicalText();
            if ("java.lang.String".equals(psiTypeText)) {
                return false;
            }
            return "org.springframework.core.io.Resource".equals(psiTypeText) || "java.io.File".equals(psiTypeText) || InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.io.InputStream");
        }
    }
}

