/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSpiClassesListJamConverter
extends JamConverter<PsiClass> {
    private final String myConfigKey;

    public SpringSpiClassesListJamConverter(String configKey) {
        this.myConfigKey = configKey;
    }

    @Nullable
    public PsiClass fromString(@Nullable String s, JamStringAttributeElement<PsiClass> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiReference[] references = this.createReferences(context);
        if (references.length != 1) {
            return null;
        }
        return (PsiClass)references[0].resolve();
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiClass> context) {
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiClassesListJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringSpiClassReference(this.myConfigKey, literal, context.getStringValue())};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiClassesListJamConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    public static class SpringSpiClassReference
    extends PsiReferenceBase<PsiElement> {
        private final String myConfigKey;
        private final String myText;

        private SpringSpiClassReference(String configKey, @NotNull PsiLiteral literal, String text) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference", "<init>"));
            }
            super((PsiElement)literal);
            this.myConfigKey = configKey;
            this.myText = text;
        }

        @Nullable
        public PsiElement resolve() {
            if (StringUtil.isEmptyOrSpaces((String)this.myText)) {
                return null;
            }
            return (PsiElement)ContainerUtil.find(this.getRelevantClasses(this.getElement()), (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return myText.equals(psiClass.getQualifiedName());
                }
            });
        }

        @NotNull
        public Object[] getVariants() {
            List<PsiClass> classes = this.getRelevantClasses(this.getElement());
            Object[] objectArray = ContainerUtil.map2Array(classes, LookupElement.class, (Function)new Function<PsiClass, LookupElement>(){

                public LookupElement fun(PsiClass psiClass) {
                    return JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)psiClass.getQualifiedName(), (boolean)true).withPresentableText(psiClass.getName());
                }
            });
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference", "getVariants"));
            }
            return objectArray;
        }

        private List<PsiClass> getRelevantClasses(PsiElement literal) {
            if (literal == null) {
                return Collections.emptyList();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return Collections.emptyList();
            }
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            boolean isInTest = moduleFileIndex.isInTestSourceContent(literal.getContainingFile().getOriginalFile().getVirtualFile());
            return SpringSpiManager.getInstance(module).getClassesListValue(isInTest, this.myConfigKey);
        }
    }
}

