/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum SpringSecurityVersion {
    SpringSecurity_2_0("2.0"),
    SpringSecurity_2_0_6("2.0.6"),
    SpringSecurity_2_0_4("2.0.4"),
    SpringSecurity_3_0("3.0"),
    SpringSecurity_3_0_3("3.0.3"),
    SpringSecurity_3_1("3.1");

    private final String myName;

    private SpringSecurityVersion(String name) {
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public String getVersion() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/SpringSecurityVersion", "getVersion"));
        }
        return string;
    }

    public boolean isAtLeast(SpringSecurityVersion reference) {
        return StringUtil.compareVersionNumbers((String)this.getVersion(), (String)reference.getVersion()) >= 0;
    }
}

