/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecurityExpressionRootMethodsUtil {
    private static final String HAS_ROLE_METHOD_NAME = "hasRole";
    private static final String HAS_ANY_ROLE_METHOD_NAME = "hasAnyRole";

    @NotNull
    public static PsiReference[] createReferences(PsiElement element, Module module) {
        PsiReference[] psiReferenceArray = SecurityExpressionRootMethodsUtil.createReferences(ElementManipulators.getValueText((PsiElement)element), element, module);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "createReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public static PsiReference[] createReferences(@Nullable String text, PsiElement element, @Nullable Module module) {
        PsiMethod method;
        if (module != null && text != null && (method = SecurityExpressionRootMethodsUtil.findExpressionRootMethod(text, module)) != null) {
            ArrayList<SpringSecurityRolePsiReference> references = new ArrayList<SpringSecurityRolePsiReference>();
            ContainerUtil.addIfNotNull(references, (Object)SecurityExpressionRootMethodsUtil.createReference(element, method, module));
            if (HAS_ROLE_METHOD_NAME.equals(method.getName()) || HAS_ANY_ROLE_METHOD_NAME.equals(method.getName())) {
                for (TextRange textRange : SecurityExpressionRootMethodsUtil.getRolesTextRanges(element)) {
                    references.add(new SpringSecurityRolePsiReference(element, textRange, module));
                }
            }
            PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static Set<TextRange> getRolesTextRanges(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getRolesTextRanges"));
        }
        com.intellij.util.containers.hash.HashSet textRanges = new com.intellij.util.containers.hash.HashSet();
        final String text = psiElement.getText();
        int i = text.indexOf("(");
        int s = text.indexOf(")");
        if (i > 0 && i < s) {
            String parametersString = text.substring(i + 1, s);
            final int offset = i + 1;
            new DelimitedListProcessor(",", (Set)textRanges){
                final /* synthetic */ Set val$textRanges;
                {
                    this.val$textRanges = set;
                    super(x0);
                }

                protected void processToken(int start, int end, boolean delimitersOnly) {
                    int i2;
                    TextRange range = new TextRange(start + offset, end + offset);
                    String token = range.substring(text);
                    int i1 = token.indexOf("'");
                    if (i1 >= 0 && (i2 = token.indexOf("'", i1 + 1)) > 0) {
                        this.val$textRanges.add(new TextRange(range.getStartOffset() + i1 + 1, range.getStartOffset() + i2));
                    }
                }
            }.processText(parametersString);
        }
        return textRanges;
    }

    @Nullable
    public static PsiMethod findExpressionRootMethod(@Nullable String methodName, @Nullable Module module) {
        if (module != null && methodName != null) {
            for (PsiMethod psiMethod : SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module)) {
                if (!methodName.startsWith(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getExpressionRootClass(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass webSecurityExpressionRoot = psiFacade.findClass("org.springframework.security.web.access.expression.WebSecurityExpressionRoot", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (webSecurityExpressionRoot != null) {
            return webSecurityExpressionRoot;
        }
        return psiFacade.findClass("org.springframework.security.access.expression.SecurityExpressionRoot", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    @Nullable
    private static PsiReferenceBase createReference(PsiElement psiElement, final PsiMethod psiMethod, final Module module) {
        String name = psiMethod.getName();
        int offset = psiElement.getText().indexOf(name);
        if (offset < 0) {
            return null;
        }
        TextRange textRange = TextRange.from((int)offset, (int)name.length());
        return new PsiReferenceBase<PsiElement>(psiElement, textRange, true){

            public PsiElement resolve() {
                return psiMethod;
            }

            @NotNull
            public Object[] getVariants() {
                HashSet<PsiMethod> variants = new HashSet<PsiMethod>();
                variants.addAll(SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module));
                Object[] objectArray = ArrayUtil.toObjectArray(variants);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil$2", "getVariants"));
                }
                return objectArray;
            }
        };
    }

    @NotNull
    public static List<PsiMethod> getExpressionRootMethods(@Nullable Module module) {
        List<PsiMethod> list = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(SecurityExpressionRootMethodsUtil.getExpressionRootClass(module));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return list;
    }

    @NotNull
    private static List<PsiMethod> getExpressionRootMethods(@Nullable PsiClass psiClass) {
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (psiMethod.isConstructor() || containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName()) || !PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) continue;
                methods.add(psiMethod);
            }
        }
        ArrayList<PsiMethod> arrayList = methods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/SecurityExpressionRootMethodsUtil", "getExpressionRootMethods"));
        }
        return arrayList;
    }
}

