/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters.roles;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityRole;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesFactory
implements Disposable {
    private static final Function<SpringSecurityRole, Object> VARIANT_FUNCTION = new Function<SpringSecurityRole, Object>(){

        public Object fun(SpringSecurityRole role) {
            return LookupElementBuilder.create((PsiNamedElement)role).withIcon(role.getIcon()).withTailText(" (" + role.getLocationString() + ")", true);
        }
    };
    private static final List<String> PREDEFINED_ROLES = Arrays.asList("IS_AUTHENTICATED_ANONYMOUSLY", "IS_AUTHENTICATED_FULLY", "IS_AUTHENTICATED_REMEMBERED");
    private static final Function<String, Object> PREDEFINED_VARIANT_FUNCTION = new Function<String, Object>(){

        public Object fun(String s) {
            return LookupElementBuilder.create((String)s).withIcon(SpringApiIcons.Spring).bold();
        }
    };
    private final Set<SpringSecurityRole> myRoles = new CopyOnWriteArraySet<SpringSecurityRole>();
    private final Map<PsiFile, Long> myContributors = new ConcurrentHashMap<PsiFile, Long>();
    private final PsiFile myDummyFile;

    public static SpringSecurityRolesFactory getInstance(Module module) {
        return (SpringSecurityRolesFactory)ModuleServiceManager.getService((Module)module, SpringSecurityRolesFactory.class);
    }

    public SpringSecurityRolesFactory(Module module) {
        this.myDummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("dummy_security_roles.java", "");
    }

    @NotNull
    public SpringSecurityRole getOrCreateRole(String roleName, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/spring/security/model/xml/converters/roles/SpringSecurityRolesFactory", "getOrCreateRole"));
        }
        if (this.myContributors.containsKey(containingFile) && this.myContributors.get(containingFile).longValue() != containingFile.getModificationStamp()) {
            this.myRoles.clear();
            this.myContributors.clear();
        }
        for (SpringSecurityRole securityRole : this.myRoles) {
            if (!roleName.equals(securityRole.getName())) continue;
            SpringSecurityRole springSecurityRole = securityRole;
            if (springSecurityRole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/roles/SpringSecurityRolesFactory", "getOrCreateRole"));
            }
            return springSecurityRole;
        }
        SpringSecurityRole role = new SpringSecurityRole(roleName, containingFile.getName(), this.myDummyFile);
        this.myRoles.add(role);
        this.myContributors.put(containingFile, containingFile.getModificationStamp());
        SpringSecurityRole springSecurityRole = role;
        if (springSecurityRole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/converters/roles/SpringSecurityRolesFactory", "getOrCreateRole"));
        }
        return springSecurityRole;
    }

    public Object[] getRolesVariants() {
        return ContainerUtil.map2Array(this.myRoles, VARIANT_FUNCTION);
    }

    public Object[] getPredefinedRolesVariants() {
        return ContainerUtil.map2Array(PREDEFINED_ROLES, PREDEFINED_VARIANT_FUNCTION);
    }

    public void dispose() {
        this.myRoles.clear();
        this.myContributors.clear();
    }
}

