/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationVariableTypeFixProvider
implements ChangeVariableTypeQuickFixProvider {
    private static final Logger LOG1 = Logger.getInstance((String)("#" + TypeMigrationVariableTypeFixProvider.class.getName()));

    @NotNull
    public IntentionAction[] getFixes(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        if (toReturn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReturn", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        IntentionAction[] intentionActionArray = new IntentionAction[]{TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn)};
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "getFixes"));
        }
        return intentionActionArray;
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        if (toReturn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReturn", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        VariableTypeFix variableTypeFix = TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn, false);
        if (variableTypeFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        return variableTypeFix;
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn, final boolean optimizeImports) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        if (toReturn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReturn", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        VariableTypeFix variableTypeFix = new VariableTypeFix(variable, toReturn){

            @NotNull
            public String getText() {
                String string = "Migrate '" + this.myName + "' type to '" + this.getReturnType().getCanonicalText() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "getText"));
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1", "invoke"));
                }
                TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)startElement, this.getReturnType(), editor, optimizeImports);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        if (variableTypeFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "createTypeMigrationFix"));
        }
        return variableTypeFix;
    }

    public static void runTypeMigrationOnVariable(@NotNull PsiVariable variable, @NotNull PsiType targetType, @Nullable(value="is null when called from inspection") Editor editor, boolean optimizeImports) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "runTypeMigrationOnVariable"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider", "runTypeMigrationOnVariable"));
        }
        Project project = variable.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(variable.getContainingFile())) {
            return;
        }
        try {
            variable.normalizeDeclaration();
            TypeMigrationRules rules = new TypeMigrationRules();
            rules.setBoundScope((SearchScope)GlobalSearchScope.projectScope((Project)project));
            TypeMigrationProcessor.runHighlightingTypeMigration((Project)project, (Editor)editor, (TypeMigrationRules)rules, (PsiElement)variable, (PsiType)targetType, (boolean)optimizeImports);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)variable);
            UndoUtil.markPsiFileForUndo((PsiFile)variable.getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG1.error((Throwable)e);
        }
    }
}

