/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaConversionUtil {
    @Nullable
    public static PsiType getFunctionReturnType(PsiExpression functionExpression) {
        if (functionExpression instanceof PsiFunctionalExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)functionExpression));
        }
        PsiType currentType = functionExpression.getType();
        if (currentType == null) {
            return null;
        }
        block0: do {
            if (LambdaUtil.isFunctionalType((PsiType)currentType)) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
            }
            PsiType[] superTypes = currentType.getSuperTypes();
            currentType = null;
            for (PsiType type : superTypes) {
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
                if (aClass == null || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)GuavaLambda.FUNCTION.getClassQName())) continue;
                currentType = type;
                continue block0;
            }
        } while (currentType != null);
        return null;
    }

    @NotNull
    public static PsiType addTypeParameters(@NotNull String baseClassQualifiedName, @Nullable PsiType type, @NotNull PsiElement context) {
        String canonicalText;
        if (baseClassQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQualifiedName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        String parameterText = "";
        if (type != null && (canonicalText = type.getCanonicalText(false)).contains("<")) {
            parameterText = canonicalText.substring(canonicalText.indexOf(60));
        }
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(baseClassQualifiedName + parameterText, context);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        return psiType;
    }

    public static boolean isJavaLambda(PsiElement element, TypeEvaluator evaluator) {
        PsiElement parent;
        if (element instanceof PsiLocalVariable) {
            return GuavaLambda.findJavaAnalogueFor(evaluator.getType(element)) != null;
        }
        if (element instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = evaluator.getType(methodOrLambda);
            }
            return GuavaLambda.findJavaAnalogueFor(methodReturnType) != null;
        }
        if (element instanceof PsiExpressionList && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
            return evaluator.getType(parent) != null;
        }
        return false;
    }

    public static PsiExpression adjustLambdaContainingExpression(PsiExpression expression, boolean insertTypeCase, PsiType targetType, TypeEvaluator evaluator) {
        GuavaLambda lambda;
        PsiExpression qualifier;
        PsiType evaluatedType;
        GuavaLambda lambda2;
        if (expression instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)expression).getAnonymousClass();
            if (anonymousClass != null) {
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda((PsiAnonymousClass)anonymousClass, (boolean)true)) {
                    return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, (boolean)true, (boolean)true);
                }
            } else {
                GuavaLambda lambda3 = GuavaLambda.findFor(evaluator.evaluateType(expression));
                return lambda3 == null ? expression : GuavaConversionUtil.addMethodReference(expression, lambda3);
            }
        }
        if (expression instanceof PsiMethodReferenceExpression && (lambda2 = GuavaLambda.findJavaAnalogueFor(evaluatedType = evaluator.evaluateType(qualifier = ((PsiMethodReferenceExpression)expression).getQualifierExpression()))) != null) {
            return GuavaConversionUtil.adjustLambdaContainingExpression((PsiExpression)expression.replace((PsiElement)qualifier), insertTypeCase, targetType, evaluator);
        }
        if (expression instanceof PsiFunctionalExpression) {
            if (insertTypeCase) {
                return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("((" + targetType.getCanonicalText() + ")" + expression.getText() + ")", (PsiElement)expression);
            }
        } else if ((expression instanceof PsiMethodCallExpression || expression instanceof PsiReferenceExpression) && (lambda = GuavaLambda.findFor(evaluator.evaluateType(expression))) != null) {
            expression = GuavaConversionUtil.addMethodReference(expression, lambda);
            return GuavaConversionUtil.adjustLambdaContainingExpression(expression, insertTypeCase, targetType, evaluator);
        }
        return expression;
    }

    private static PsiExpression addMethodReference(@NotNull PsiExpression expression, @NotNull GuavaLambda lambda) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addMethodReference"));
        }
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addMethodReference"));
        }
        return (PsiExpression)expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + lambda.getSamName(), (PsiElement)expression));
    }
}

