/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.EmulatorUtil;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MobileSdkConfigurable
implements AdditionalDataConfigurable {
    private JPanel myWholePanel;
    private JComboBox myInheritedJavaSDK;
    private final DefaultComboBoxModel myJavaSdkList;
    private Sdk myMobileJdk;
    private final SdkModel mySdkModel;
    private final SdkModificator mySdkModificator;
    private JPanel myMIDPPanel;
    private JTextField myPreverifyOptions;
    private EmulatorType myEmulatorType;
    private MobileApiSettingsEditor myApiEditor;
    private final SdkModel.Listener myListener;

    public MobileSdkConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        this.$$$setupUI$$$();
        this.myJavaSdkList = new DefaultComboBoxModel();
        this.mySdkModel = sdkModel;
        this.mySdkModificator = sdkModificator;
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    MobileSdkConfigurable.this.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    MobileSdkConfigurable.this.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    MobileSdkConfigurable.this.updateJavaSdkList(sdk, previousName);
                }
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                if (sdk.getSdkType().equals((Object)MobileSdk.getInstance())) {
                    MobileSdkConfigurable.this.homePathChanged(newSdkHome);
                }
            }
        };
        this.mySdkModel.addListener(this.myListener);
        this.myInheritedJavaSDK.setModel(this.myJavaSdkList);
        this.myInheritedJavaSDK.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Sdk) {
                    this.setText(((Sdk)value).getName());
                }
            }
        });
        this.myMIDPPanel.setLayout(new BorderLayout());
        this.restoreCurrentJavaSdks();
    }

    private void restoreCurrentJavaSdks() {
        this.myJavaSdkList.removeAllElements();
        Sdk[] allJdks = this.mySdkModel.getSdks();
        for (int i = 0; allJdks != null && i < allJdks.length; ++i) {
            if (!Comparing.equal((Object)allJdks[i].getSdkType(), (Object)JavaSdk.getInstance())) continue;
            this.myJavaSdkList.addElement(allJdks[i]);
        }
    }

    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        Emulator emulator = null;
        boolean isModified = this.myMobileJdk != null && this.myMobileJdk.getSdkAdditionalData() != null && this.myJavaSdkList.getSelectedItem() != null ? !Comparing.equal((String)(emulator = (Emulator)this.myMobileJdk.getSdkAdditionalData()).getJavaSdkName(), (String)((Sdk)this.myJavaSdkList.getSelectedItem()).getName()) : true;
        if (emulator != null && this.myPreverifyOptions.getText() != null) {
            isModified |= !Arrays.equals(emulator.getPreverifyOptions(), MobileSdkConfigurable.getStringArrayWithoutEmptyStrings(this.myPreverifyOptions.getText().split(" ")));
        }
        if (this.myApiEditor != null) {
            isModified |= this.myApiEditor.isModified();
        }
        return isModified;
    }

    private static String[] getStringArrayWithoutEmptyStrings(String[] array) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; array != null && i < array.length; ++i) {
            if (array[i].length() == 0) continue;
            result.add(array[i]);
        }
        return ArrayUtil.toStringArray(result);
    }

    public void apply() throws ConfigurationException {
        if (this.myInheritedJavaSDK.getSelectedIndex() == -1) {
            this.restoreCurrentJavaSdks();
            throw new ConfigurationException(J2MEBundle.message("jdk.no.javasdk.specified", new Object[0]));
        }
        Sdk jdk = (Sdk)this.myJavaSdkList.getSelectedItem();
        if (jdk == null) {
            this.restoreCurrentJavaSdks();
            throw new ConfigurationException(J2MEBundle.message("jdk.no.javasdk.specified", new Object[0]));
        }
        String[] preverifyOptions = this.myPreverifyOptions.getText() != null ? this.myPreverifyOptions.getText().split(" ") : null;
        Emulator emulator = new Emulator(this.myEmulatorType, MobileSdkConfigurable.getStringArrayWithoutEmptyStrings(preverifyOptions), jdk.getName(), this.myMobileJdk.getHomePath());
        if (this.myApiEditor != null) {
            this.myApiEditor.applyEditorTo(emulator);
        }
        final SdkModificator modificator = this.myMobileJdk.getSdkModificator();
        modificator.setVersionString(jdk.getVersionString());
        modificator.setSdkAdditionalData((SdkAdditionalData)emulator);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                modificator.commitChanges();
            }
        });
    }

    public void reset() {
        if (MobileSdk.checkCorrectness(this.myMobileJdk, null)) {
            Emulator emulator = (Emulator)this.myMobileJdk.getSdkAdditionalData();
            this.myJavaSdkList.setSelectedItem(emulator.getJavaSdk(this.mySdkModel));
            this.myEmulatorType = emulator.getEmulatorType();
            String homePath = this.myMobileJdk.getHomePath();
            if (this.myEmulatorType == null) {
                this.myEmulatorType = EmulatorUtil.getValidEmulatorType(homePath);
                if (this.myEmulatorType instanceof MIDPEmulatorType) {
                    this.reconfigureMIDPPanel(homePath);
                }
            }
            emulator.setHome(homePath);
            if (this.myApiEditor != null) {
                this.myMIDPPanel.setVisible(true);
                this.myApiEditor.resetEditorFrom(emulator);
            } else {
                this.myMIDPPanel.setVisible(false);
            }
            String[] preverifyOptions = emulator.getPreverifyOptions();
            if (preverifyOptions != null && preverifyOptions.length > 0) {
                String options = "";
                for (String preverifyOption : preverifyOptions) {
                    options = options + preverifyOption + " ";
                }
                this.myPreverifyOptions.setText(options);
            } else {
                this.myPreverifyOptions.setText("");
            }
        }
    }

    public void disposeUIResources() {
        if (this.myApiEditor != null) {
            Disposer.dispose((Disposable)this.myApiEditor);
        }
        this.mySdkModel.removeListener(this.myListener);
    }

    public void setSdk(Sdk sdk) {
        this.myMobileJdk = sdk;
        this.homePathChanged(sdk.getHomePath());
    }

    private void homePathChanged(String homePath) {
        if (this.myApiEditor != null) {
            Disposer.dispose((Disposable)this.myApiEditor);
            this.myApiEditor = null;
        }
        this.myEmulatorType = EmulatorUtil.getValidEmulatorType(homePath);
        if (!(this.myEmulatorType instanceof MIDPEmulatorType)) {
            this.myMIDPPanel.setVisible(false);
        } else {
            this.myMIDPPanel.setVisible(true);
            this.reconfigureMIDPPanel(homePath);
            this.myApiEditor.resetEditorFrom(new Emulator(this.myEmulatorType, null, null, homePath));
        }
    }

    private void reconfigureMIDPPanel(String homePath) {
        this.myMIDPPanel.removeAll();
        this.myApiEditor = ((MIDPEmulatorType)this.myEmulatorType).getApiEditor(homePath, this.myMobileJdk, this.mySdkModificator);
        this.myMIDPPanel.add((Component)this.myApiEditor.createEditor(), "Center");
    }

    private void addJavaSdk(Sdk sdk) {
        this.myJavaSdkList.addElement(sdk);
    }

    private void removeJavaSdk(Sdk sdk) {
        this.myJavaSdkList.removeElement(sdk);
    }

    private void updateJavaSdkList(Sdk sdk, String previousName) {
        Sdk[] sdks;
        for (Sdk currentSdk : sdks = this.mySdkModel.getSdks()) {
            Emulator emulator;
            if (!Comparing.equal((Object)currentSdk.getSdkType(), (Object)((Object)MobileSdk.getInstance())) || !Comparing.equal((String)(emulator = (Emulator)currentSdk.getSdkAdditionalData()).getJavaSdkName(), (String)previousName)) continue;
            emulator.setJavaSdk(sdk.getName());
        }
        this.restoreCurrentJavaSdks();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.choose.javasdk"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInheritedJavaSDK = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("emulator.preverify.parameters"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPreverifyOptions = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMIDPPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

