/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class J2MEModuleResourcesStep
extends ModuleWizardStep {
    private final WizardContext myContext;
    private final J2MEModuleBuilder myModuleBuilder;
    private JPanel myWholePanel;
    private JLabel myExplanation;
    private JCheckBox mySetupResourseFolder;
    private FieldPanel myResourcesDirectory;
    private String myDefaultResourceDirectoryPath;
    private final Icon myIcon;
    private final String myHelpId;

    public J2MEModuleResourcesStep(WizardContext wizardContext, J2MEModuleBuilder moduleBuilder, Icon wizardIcon, @NonNls String s) {
        this.myContext = wizardContext;
        this.myModuleBuilder = moduleBuilder;
        this.myIcon = wizardIcon;
        this.myHelpId = s;
        this.$$$setupUI$$$();
        this.myExplanation.setText("");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySetupResourseFolder.isSelected() ? this.myResourcesDirectory.getTextField() : this.mySetupResourseFolder;
    }

    public JComponent getComponent() {
        String res = "res";
        this.myDefaultResourceDirectoryPath = this.myModuleBuilder.getModuleFileDirectory() != null ? this.myModuleBuilder.getModuleFileDirectory().replace('/', File.separatorChar) + File.separator + "res" : "";
        this.mySetupResourseFolder.setSelected(this.myModuleBuilder.getResourcesDirPath() != null);
        this.setUpResourceDirectoryPanel();
        this.mySetupResourseFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J2MEModuleResourcesStep.this.setUpResourceDirectoryPanel();
            }
        });
        this.myResourcesDirectory.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setTitle(J2MEBundle.message("resource.directory.chooser.title", new Object[0]));
                descriptor.setDescription(J2MEBundle.message("resource.directory.chooser", new Object[0]));
                VirtualFile initial = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)J2MEModuleResourcesStep.this.myModuleBuilder.getModuleFileDirectory()));
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)J2MEModuleResourcesStep.this.myWholePanel, (Project)J2MEModuleResourcesStep.this.myContext.getProject(), (VirtualFile)initial);
                if (file != null) {
                    J2MEModuleResourcesStep.this.myResourcesDirectory.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        this.myResourcesDirectory.createComponent();
        this.myWholePanel.setBorder(BorderFactory.createEtchedBorder());
        return this.myWholePanel;
    }

    private void setUpResourceDirectoryPanel() {
        if (this.mySetupResourseFolder.isSelected()) {
            this.myResourcesDirectory.setEnabled(true);
            if (this.myModuleBuilder.isDefaultRDirectoryModified()) {
                this.myResourcesDirectory.setText(this.myModuleBuilder.getResourcesDirPath());
            } else {
                this.myResourcesDirectory.setText(this.myDefaultResourceDirectoryPath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        J2MEModuleResourcesStep.this.myResourcesDirectory.getTextField().selectAll();
                        J2MEModuleResourcesStep.this.myResourcesDirectory.getTextField().requestFocus();
                    }
                });
            }
        } else {
            this.myResourcesDirectory.setEnabled(false);
        }
    }

    public void updateDataModel() {
        if (this.mySetupResourseFolder.isSelected()) {
            this.myModuleBuilder.setResourcesDirPath(this.myResourcesDirectory.getText());
            this.myModuleBuilder.setDefaultRDirectoryModified(!this.myDefaultResourceDirectoryPath.equals(this.myResourcesDirectory.getText()));
        } else {
            this.myModuleBuilder.setResourcesDirPath(null);
        }
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void onStepLeaving() {
        this.updateDataModel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FieldPanel fieldPanel;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 3, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExplanation = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("resource.directory.explanation"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySetupResourseFolder = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("resource.directory.enabled"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myResourcesDirectory = fieldPanel = new FieldPanel();
        jPanel2.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(250, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

