/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public abstract class JavaeeProjectDataService<E extends ExternalEntityData, FACET extends JavaeeFacet, FACET_CONFIG extends JavaeeFacetConfiguration, FACET_TYPE extends JavaeeFacetType<FACET, FACET_CONFIG>>
extends AbstractProjectDataService<E, Artifact> {
    private static final Logger LOG = Logger.getInstance(JavaeeProjectDataService.class);
    private final FACET_TYPE myJavaeeFacetType;

    public JavaeeProjectDataService(FACET_TYPE javaeeFacetType) {
        this.myJavaeeFacetType = javaeeFacetType;
    }

    protected abstract void configureJavaeeModule(@NotNull ModuleData var1, @NotNull E var2, @NotNull IdeModifiableModelsProvider var3);

    protected abstract ArtifactType getArtifactType(boolean var1);

    protected abstract Collection<String> resolveArtifactNames(@NotNull ModuleData var1, @NotNull E var2);

    public FACET_TYPE getJavaeeFacetType() {
        return this.myJavaeeFacetType;
    }

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "importData"));
        }
        if (this.myJavaeeFacetType == null) {
            return;
        }
        for (DataNode<E> node : toImport) {
            Object parentNodeData;
            DataNode parentNode;
            final ExternalEntityData data = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)data.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            final ModuleData moduleData = (ModuleData)parentNodeData;
            ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                public void execute() {
                    JavaeeProjectDataService.this.configureJavaeeModule(moduleData, data, modelsProvider);
                }
            });
        }
    }

    @NotNull
    public Computable<Collection<Artifact>> computeOrphanData(final @NotNull Collection<DataNode<E>> toImport, final @NotNull ProjectData projectData, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        Computable<Collection<Artifact>> computable = new Computable<Collection<Artifact>>(){

            public Collection<Artifact> compute() {
                List orphanArtifacts = ContainerUtil.newSmartList();
                AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectData.getOwner());
                List linkedProjectsPaths = ContainerUtil.map((Collection)settings.getLinkedProjectsSettings(), (Function)new Function<ExternalProjectSettings, String>(){

                    public String fun(ExternalProjectSettings settings) {
                        return settings.getExternalProjectPath();
                    }
                });
                List importedArtifacts = JavaeeProjectDataService.this.resolveArtifactNames(toImport);
                ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
                for (Artifact artifact : artifactModel.getAllArtifactsIncludingInvalid()) {
                    String externalProjectPath;
                    Object state;
                    if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)JavaeeProjectDataService.this.myJavaeeFacetType) || !((state = artifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance()).getState()) instanceof GradleArtifactProperties) || linkedProjectsPaths.contains(externalProjectPath = ((GradleArtifactProperties)((Object)state)).getExternalProjectPath()) && (!projectData.getLinkedExternalProjectPath().equals(externalProjectPath) || importedArtifacts.contains(artifact.getName()))) continue;
                    orphanArtifacts.add(artifact);
                }
                return orphanArtifacts;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "computeOrphanData"));
        }
        return computable;
    }

    public void removeData(@NotNull Computable<Collection<Artifact>> toRemove, @NotNull Collection<DataNode<E>> toIgnore, final @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "removeData"));
        }
        List<String> ignoredArtifacts = this.resolveArtifactNames(toIgnore);
        List artifactsToRemove = ContainerUtil.newSmartList();
        artifactsToRemove.addAll((Collection)toRemove.compute());
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        for (Artifact artifact : artifactsToRemove) {
            artifactModel.removeArtifact(artifact);
        }
        for (Artifact artifact : (List)new GradleArtifactsFinder(artifactModel, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType).getValue()) {
            if (!ignoredArtifacts.contains(artifact.getName())) continue;
            artifactModel.removeArtifact(artifact);
        }
        if (this.myJavaeeFacetType != null) {
            List orphanFacets = ContainerUtil.newSmartList();
            String gradleFacetNamePrefix = this.getFacetNamePrefix((FacetType)this.myJavaeeFacetType);
            GradleArtifactsFinder gradleArtifactsFinder = new GradleArtifactsFinder(artifactModel, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType);
            List modules = ContainerUtil.filter((Object[])modelsProvider.getModules(), (Condition)new Condition<Module>(){

                public boolean value(Module module) {
                    return projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
                }
            });
            PackagingElementResolvingContext context = modelsProvider.getPackagingElementResolvingContext();
            for (Module module : modules) {
                for (JavaeeFacet javaeeFacet : context.getFacetsProvider().getFacetsByType(module, this.myJavaeeFacetType.getId())) {
                    if (!javaeeFacet.getName().startsWith(gradleFacetNamePrefix)) continue;
                    boolean used = false;
                    List artifacts = (List)gradleArtifactsFinder.getValue();
                    for (Artifact artifact : artifacts) {
                        if (!JavaeeProjectDataService.isUsedIn(javaeeFacet, artifact, context)) continue;
                        used = true;
                        break;
                    }
                    if (used) continue;
                    orphanFacets.add(javaeeFacet);
                }
            }
            for (JavaeeFacet orphanFacet : orphanFacets) {
                if (orphanFacet.isDisposed()) continue;
                Module orphanFacetModule = orphanFacet.getModule();
                ModifiableFacetModel modifiableFacetModel = modelsProvider.getModifiableFacetModel(orphanFacetModule);
                modifiableFacetModel.removeFacet((Facet)orphanFacet);
            }
        }
    }

    protected FACET createOrReplaceFacet(ModifiableFacetModel facetModel, Module module, String facetName, FACET_TYPE javaeeFacetType) {
        Collection facets = facetModel.getFacetsByType(javaeeFacetType.getId());
        for (JavaeeFacet facet : facets) {
            if (!facetName.equals(facet.getName())) continue;
            facetModel.removeFacet((Facet)facet);
            break;
        }
        JavaeeFacet facet = (JavaeeFacet)javaeeFacetType.createFacet(module, facetName, javaeeFacetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)facet);
        return (FACET)facet;
    }

    protected String getFacetNamePrefix(@NotNull FacetType facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "getFacetNamePrefix"));
        }
        return facetType.getPresentableName() + ' ' + GradleConstants.SYSTEM_ID.getReadableName();
    }

    @Nullable
    protected String getArtifactOutputPath(String artifactName, Module module, Jar jar, boolean isExploded) {
        File outputFile;
        String defaultArtifactOutputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)artifactName, (Project)module.getProject());
        if (defaultArtifactOutputPath != null && (outputFile = new File(defaultArtifactOutputPath).getParentFile()) != null) {
            String outputPath = outputFile.getName().equals(module.getName()) ? outputFile.getPath() : outputFile.getPath() + '/' + StringUtil.trimEnd((String)module.getName(), (String)"_main");
            return FileUtil.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)(isExploded ? outputPath + "/exploded/" + jar.getName() : outputPath)));
        }
        return null;
    }

    protected void addManifest(@NotNull ModifiableArtifact modifiableArtifact, @NotNull String outputPath, @NotNull Jar jar) {
        if (modifiableArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableArtifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "addManifest"));
        }
        if (jar.getManifestContent() == null) {
            return;
        }
        try {
            VirtualFile metaInfDirectory = VfsUtil.createDirectoryIfMissing((String)(outputPath + '/' + ManifestFileUtil.MANIFEST_DIR_NAME));
            if (metaInfDirectory == null) {
                LOG.warn(String.format("Unable to create META-INF directory at path: %s", outputPath));
                return;
            }
            VirtualFile manifestVFile = metaInfDirectory.findOrCreateChildData((Object)this, ManifestFileUtil.MANIFEST_FILE_NAME);
            VfsUtil.saveText((VirtualFile)manifestVFile, (String)jar.getManifestContent());
            PackagingElementFactory.getInstance().addFileCopy(modifiableArtifact.getRootElement(), ManifestFileUtil.MANIFEST_DIR_NAME, manifestVFile.getPath(), ManifestFileUtil.MANIFEST_FILE_NAME);
        }
        catch (IOException e) {
            LOG.warn("Unable to add manifest to the artifact", (Throwable)e);
        }
    }

    protected String resolveArtifactName(@NotNull ModuleData moduleData, @NotNull String archiveName, boolean isExploded) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactName"));
        }
        if (archiveName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveName", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactName"));
        }
        String artifactNamePrefix = GradleConstants.SYSTEM_ID.getReadableName();
        StringBuilder buf = new StringBuilder(artifactNamePrefix);
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(" : ").append(moduleData.getGroup());
        }
        String artifactName = this.adjustName(buf.toString(), archiveName);
        return isExploded ? artifactName + " (exploded)" : artifactName;
    }

    @NotNull
    protected String formatModuleArchiveFileName(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "formatModuleArchiveFileName"));
        }
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(moduleData.getGroup()).append('-');
        }
        buf.append(StringUtil.trimEnd((String)moduleData.getExternalName(), (String)":main"));
        if (!StringUtil.isEmpty((String)moduleData.getVersion()) && !"unspecified".equals(moduleData.getVersion())) {
            buf.append('-').append(moduleData.getVersion());
        }
        String string = PathUtilRt.suggestFileName((String)buf.append(".jar").toString(), (boolean)true, (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "formatModuleArchiveFileName"));
        }
        return string;
    }

    protected String adjustName(@NotNull String namePrefix, @Nullable String archiveName) {
        if (namePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePrefix", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "adjustName"));
        }
        return StringUtil.replaceChar((String)(namePrefix + (StringUtil.isEmpty((String)archiveName) ? "" : " : " + archiveName)), (char)'/', (char)'_');
    }

    private static boolean isUsedIn(final @NotNull JavaeeFacet javaeeFacet, @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context) {
        if (javaeeFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacet", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isUsedIn"));
        }
        final Ref result = Ref.create((Object)Boolean.FALSE);
        ArtifactUtil.processPackagingElements((Artifact)artifact, null, (Processor)new Processor<PackagingElement<?>>(){

            public boolean process(@NotNull PackagingElement<?> element) {
                Facet facet;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService$4", "process"));
                }
                if (element instanceof FacetBasedPackagingElement && javaeeFacet.equals((Object)(facet = ((FacetBasedPackagingElement)element).findFacet(context)))) {
                    result.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return (Boolean)result.get();
    }

    @NotNull
    private List<String> resolveArtifactNames(@NotNull Collection<DataNode<E>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactNames"));
        }
        List artifacts = ContainerUtil.newSmartList();
        for (DataNode<E> node : nodes) {
            Object parentNodeData;
            DataNode parentNode;
            ExternalEntityData earConfigurationModelData = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)earConfigurationModelData.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)parentNodeData;
            artifacts.addAll(this.resolveArtifactNames(moduleData, earConfigurationModelData));
        }
        List list = artifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "resolveArtifactNames"));
        }
        return list;
    }

    private static boolean isGradleJeeArtifact(@NotNull Artifact artifact, @NotNull JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isGradleJeeArtifact"));
        }
        if (javaeeFacetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeFacetType", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService", "isGradleJeeArtifact"));
        }
        boolean isOurType = false;
        for (ArtifactType artifactType : javaeeFacetType.getArtifactTypes()) {
            isOurType = isOurType || artifact.getArtifactType().equals(artifactType);
        }
        return isOurType && artifact.getName().startsWith(GradleConstants.SYSTEM_ID.getReadableName());
    }

    private static class GradleArtifactsFinder
    extends NotNullLazyValue<List<? extends Artifact>> {
        private final ModifiableArtifactModel myArtifactModel;
        private final JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> myJavaeeFacetType;

        public GradleArtifactsFinder(ModifiableArtifactModel artifactModel, JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
            this.myArtifactModel = artifactModel;
            this.myJavaeeFacetType = javaeeFacetType;
        }

        @NotNull
        protected List<? extends Artifact> compute() {
            List result = ContainerUtil.newSmartList();
            for (Artifact artifact : this.myArtifactModel.getAllArtifactsIncludingInvalid()) {
                if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)this.myJavaeeFacetType)) continue;
                result.add(artifact);
            }
            List list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/javaee/JavaeeProjectDataService$GradleArtifactsFinder", "compute"));
            }
            return list;
        }
    }
}

