/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addsubtag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.addsubtag.AddSubtag;
import com.sixrr.xrp.addsubtag.AddSubtagUsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddSubtagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String subtagName;
    private final boolean addOnlyIfAbsent;
    private final Context context;

    AddSubtagProcessor(XmlTag tag, String subtagName, boolean addOnlyIfAbsent, Context context, boolean previewUsages) {
        super(tag.getProject(), previewUsages);
        this.subtagName = subtagName;
        this.tag = tag;
        this.addOnlyIfAbsent = addOnlyIfAbsent;
        this.context = context;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/addsubtag/AddSubtagProcessor", "createUsageViewDescriptor"));
        }
        AddSubtagUsageViewDescriptor addSubtagUsageViewDescriptor = new AddSubtagUsageViewDescriptor(this.tag, usageInfos);
        if (addSubtagUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/addsubtag/AddSubtagProcessor", "createUsageViewDescriptor"));
        }
        return addSubtagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/addsubtag/AddSubtagProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (this.addOnlyIfAbsent && this.subtagExists(xmlTag)) continue;
            usages.add(new AddSubtag(xmlTag, this.subtagName));
        }
    }

    private boolean subtagExists(XmlTag xmlTag) {
        XmlTag[] subtags;
        for (XmlTag subtag : subtags = xmlTag.getSubTags()) {
            if (!subtag.getName().equals(this.subtagName)) continue;
            return true;
        }
        return false;
    }

    protected String getCommandName() {
        return "Add subtag " + this.subtagName + " to tag " + this.tag.getName();
    }
}

