/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.sixrr.xrp.attributetotag.AttributeToTagDialog;
import com.sixrr.xrp.attributetotag.AttributeToTagProcessor;
import com.sixrr.xrp.base.BaseAttributeRefactoringHandler;
import com.sixrr.xrp.context.Context;

class AttributeToTagHandler
extends BaseAttributeRefactoringHandler {
    AttributeToTagHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.attributeToTag";
    }

    @Override
    protected String getRefactoringName() {
        return "Attribute To Tag";
    }

    @Override
    protected void handleAttribute(final XmlAttribute attribute, Project project) {
        AttributeToTagDialog dialog = new AttributeToTagDialog(attribute);
        if (!dialog.showAndGet()) {
            return;
        }
        final Context context = dialog.getContext();
        final String tagName = dialog.getTagName();
        final boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        AttributeToTagProcessor processor = new AttributeToTagProcessor(attribute, tagName, context, previewUsages);
                        processor.run();
                    }
                };
                Application application = ApplicationManager.getApplication();
                application.runWriteAction(action);
            }
        }, "Replace Attribute With Tag", null);
    }
}

