/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.intention.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
implements IntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/intention/Intention", "invoke"));
        }
        if (Intention.isFileReadOnly(project, file)) {
            return;
        }
        PsiElement element = this.findMatchingElement(file, editor);
        if (element == null) {
            return;
        }
        this.processIntention(element);
    }

    protected abstract void processIntention(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    @Nullable
    private PsiElement findMatchingElement(PsiFile file, Editor editor) {
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        for (PsiElement element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (!this.predicate.satisfiedBy(element)) continue;
            return element;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/intention/Intention", "isAvailable"));
        }
        return this.findMatchingElement(file, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static boolean isFileReadOnly(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        ReadonlyStatusHandler statusHandler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = statusHandler.ensureFilesWritable(new VirtualFile[]{virtualFile});
        return status.hasReadonlyFiles();
    }
}

