/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renameattribute;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.sixrr.xrp.base.BaseAttributeRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.renameattribute.RenameAttributeDialog;
import com.sixrr.xrp.renameattribute.RenameAttributeProcessor;

class RenameAttributeHandler
extends BaseAttributeRefactoringHandler {
    RenameAttributeHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.renameAttribute";
    }

    @Override
    protected String getRefactoringName() {
        return "Rename attribute";
    }

    @Override
    protected void handleAttribute(final XmlAttribute attribute, Project project) {
        RenameAttributeDialog dialog = new RenameAttributeDialog(attribute);
        if (!dialog.showAndGet()) {
            return;
        }
        final Context context = dialog.getContext();
        final boolean previewUsages = dialog.isPreviewUsages();
        final String newAttributeName = dialog.getNewAttributeName();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        RenameAttributeProcessor processor = new RenameAttributeProcessor(attribute, newAttributeName, context, previewUsages);
                        processor.run();
                    }
                };
                Application application = ApplicationManager.getApplication();
                application.runWriteAction(action);
            }
        }, "Rename Attribute", null);
    }
}

