/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteCredentialsDialogRunner;
import com.jetbrains.plugins.remotesdk.console.WebServerConnector;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDataProducer {
    public static final String NO_HOST_TO_CONNECT = "No Host To Connect";
    private Project myProject;
    private Module myModule;
    private AnActionEvent myActionEvent;
    private boolean myShowProjectLevelServers = false;
    private Component myComponentOwner;

    public RemoteDataProducer withComponentOwner(@NotNull Component componentOwner) {
        if (componentOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentOwner", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer", "withComponentOwner"));
        }
        this.myComponentOwner = componentOwner;
        return this;
    }

    public RemoteDataProducer withProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer", "withProject"));
        }
        this.myProject = project;
        return this;
    }

    public RemoteDataProducer withModule(@Nullable Module module) {
        this.myModule = module;
        return this;
    }

    public RemoteDataProducer withShowProjectLevelServers(boolean show) {
        this.myShowProjectLevelServers = show;
        return this;
    }

    public RemoteDataProducer withActionEvent(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer", "withActionEvent"));
        }
        this.myActionEvent = event;
        this.myProject = (Project)event.getData(CommonDataKeys.PROJECT);
        this.myModule = (Module)event.getData(LangDataKeys.MODULE);
        return this;
    }

    private Project getProjectForServersSearch() {
        return this.myShowProjectLevelServers ? this.myProject : null;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(@Nullable RemoteConnectionType type, @Nullable String id) {
        WebServerConfig config;
        if (type == RemoteConnectionType.DEPLOYMENT_SERVER && (config = RemoteDataProducer.findDeploymentServerById(id, this.getProjectForServersSearch())) != null) {
            return new WebServerConnector(config);
        }
        if (type != null) {
            for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
                RemoteConnector connector = provider.getRemoteConnector(type, id, this.myProject, this.myModule);
                if (connector == null) continue;
                return connector;
            }
        }
        return null;
    }

    @Nullable
    private static WebServerConfig findDeploymentServerById(@Nullable String id, @Nullable Project project) {
        if (id != null) {
            for (WebServerConfig config : RemoteSdkUtil.getSftpServerList(project)) {
                if (!id.equals(config.getId())) continue;
                return config;
            }
        }
        return null;
    }

    public void produceRemoteData(@Nullable RemoteConnectionType type, @Nullable String id, final @NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer", "produceRemoteData"));
        }
        RemoteConnector connector = this.getRemoteConnector(type, id);
        if (connector != null) {
            connector.produceRemoteCredentials((Consumer)new Consumer<RemoteCredentials>(){

                public void consume(RemoteCredentials credentials) {
                    if (credentials != null) {
                        consumer.consume((Object)credentials);
                    }
                }
            });
        } else {
            this.selectConnectionInPopup(consumer);
        }
    }

    public void selectConnectionInPopup(final Consumer<RemoteCredentials> consumer) {
        List<RemoteConnector> connectors = RemoteConnectionUtil.getUniqueRemoteConnectors(this.getProjectForServersSearch());
        if (connectors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Please specify SFTP server in Deployment settings");
            for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
                String description = provider.getSettingCreationDescription();
                if (description == null) continue;
                message.append(" or ").append(description);
            }
            Messages.showWarningDialog((Project)this.myProject, (String)message.toString(), (String)NO_HOST_TO_CONNECT);
        } else {
            Collections.sort(connectors, (c1, c2) -> c1.getType() == RemoteConnectionType.NONE ? -1 : (c2.getType() == RemoteConnectionType.NONE ? 1 : c1.getName().compareTo(c2.getName())));
            BaseListPopupStep<RemoteConnector> sdkHomesStep = new BaseListPopupStep<RemoteConnector>("Select host to connect", connectors){

                @NotNull
                public String getTextFor(RemoteConnector value) {
                    if (value.getType() == RemoteConnectionType.NONE) {
                        if ("Edit credentials..." == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer$2", "getTextFor"));
                        }
                        return "Edit credentials...";
                    }
                    String string = value.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer$2", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(final RemoteConnector selected, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (selected == RemoteConnectionSettingsForm.NONE_CONNECTOR) {
                                new RemoteCredentialsDialogRunner().run(RemoteDataProducer.this.myProject, (Consumer<RemoteCredentials>)consumer);
                            } else {
                                selected.produceRemoteCredentials((Consumer)new Consumer<RemoteCredentials>(){

                                    public void consume(RemoteCredentials credentials) {
                                        consumer.consume((Object)credentials);
                                    }
                                });
                            }
                        }
                    });
                    return FINAL_CHOICE;
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
            if (this.myComponentOwner != null) {
                popup.showInCenterOf(this.myComponentOwner);
            } else if (this.myProject != null) {
                if (this.myActionEvent != null && this.myActionEvent.getInputEvent() instanceof KeyEvent) {
                    popup.showInFocusCenter();
                } else {
                    popup.showInScreenCoordinates((Component)WindowManager.getInstance().getIdeFrame(this.myProject).getComponent(), MouseInfo.getPointerInfo().getLocation());
                }
            } else {
                popup.showInFocusCenter();
            }
        }
    }
}

