/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalView;

public class RunSshConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOGGER = Logger.getInstance(RunSshConsoleAction.class);

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.runSshConsole(e);
    }

    public void runSshConsole(AnActionEvent event) {
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        final SshConsoleOptionsProvider optionsProvider = SshConsoleOptionsProvider.getInstance(project);
        if (project != null) {
            new RemoteDataProducer().withActionEvent(event).withShowProjectLevelServers(true).produceRemoteData(optionsProvider.getConnectionType(), optionsProvider.getConnectionId(), new Consumer<RemoteCredentials>(){

                public void consume(final RemoteCredentials data) {
                    final SshTerminalCachingRunner runner = new SshTerminalCachingRunner(project, data, optionsProvider.getCharset());
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RunSshConsoleAction.connectToSshUnderProgress(project, runner, data);
                        }
                    });
                }
            });
        }
    }

    private static void connectToSshUnderProgress(final Project project, final SshTerminalCachingRunner runner, final RemoteCredentials data) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Connecting to " + runner.runningTargetName(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction$2", "run"));
                }
                RunSshConsoleAction.createTerminalSession(indicator, runner, data, project, this.getTitle());
            }
        });
    }

    private static void createTerminalSession(@NotNull ProgressIndicator indicator, final SshTerminalCachingRunner runner, RemoteCredentials data, final Project project, final String title) {
        block3: {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction", "createTerminalSession"));
            }
            try {
                runner.getAndCacheSession(data);
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block3;
                LOGGER.warn("unable to get session for " + data, (Throwable)e);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title);
                    }
                });
            }
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                TerminalView.getInstance((Project)project).createNewSession(project, (AbstractTerminalRunner)runner);
            }
        });
    }
}

