/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkByDeploymentForm {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.plugins.remotesdk.ui.RemoteSdkByDeploymentForm");
    private static final WebDeploymentCredentialsHolder DEPLOYMENT_EMPTY_CREDENTIALS = new WebDeploymentCredentialsHolder();
    private static final Condition<WebServerConfig> mySftpServersFilter = new Condition<WebServerConfig>(){

        public boolean value(WebServerConfig config) {
            return config.getFileTransferConfig().getAccessType() == AccessType.SFTP;
        }
    };
    private JPanel myDeploymentPanel;
    private JLabel myDeploymentConfigurationLabel;
    protected WebServerCombo myDeploymentConfigurationsCombo;
    private JLabel myDeploymentHostLabel;
    private JLabel myDeploymentUrl;
    protected JPanel myDeploymentProjectLevelServerSetupPanel;
    private ActionLink myDeploymentCreateAppLevelSeverLink;
    protected ActionLink myDeploymentMoveServerLink;
    protected JBLabel myDeploymentLevelWarningLabel;
    protected JBLabel myDeploymentMoveServerLabel;
    private JBLabel myDeploymentCreateAppLevelLabel;
    protected JPanel myCustomActionPanel;
    private JPanel myDeploymentWarningPanel;
    private JBLabel myDeploymentWarningLabel;
    private Project myProject;
    private WebDeploymentCredentialsHolder myDeploymentCredentials;

    public RemoteSdkByDeploymentForm(@Nullable Project project, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)disposable, (Disposable)this.myDeploymentConfigurationsCombo);
        List<WebServerConfig> serverList = RemoteSdkUtil.getSftpServerList(this.myProject);
        this.myDeploymentWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myDeploymentWarningPanel.setVisible(serverList.isEmpty());
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        this.myDeploymentConfigurationsCombo.setProject(project);
        this.myDeploymentConfigurationsCombo.setWebServerFilter(mySftpServersFilter);
        this.setupDeploymentCombo(serverList.isEmpty() ? null : serverList.get(0));
        this.myDeploymentConfigurationsCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            public void deploymentConfigChanged() {
                RemoteSdkByDeploymentForm.this.myDeploymentWarningPanel.setVisible(RemoteSdkUtil.getSftpServerList(RemoteSdkByDeploymentForm.this.myProject).isEmpty());
            }

            public void optionsChanged() {
            }

            public void excludedPathsChanged() {
            }
        });
        String createTooltip = "Created deployment server will be visible for all projects";
        this.myDeploymentCreateAppLevelLabel.setToolTipText("Created deployment server will be visible for all projects");
        this.myDeploymentCreateAppLevelSeverLink.setToolTipText("Created deployment server will be visible for all projects");
        String moveTooltip = "Deployment server will be visible for all projects";
        this.myDeploymentMoveServerLink.setToolTipText("Deployment server will be visible for all projects");
        this.myDeploymentMoveServerLabel.setToolTipText("Deployment server will be visible for all projects");
        this.myDeploymentProjectLevelServerSetupPanel.setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)10), (int)0, (int)0, (int)0));
    }

    public void init(@NotNull WebDeploymentCredentialsHolder cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm", "init"));
        }
        this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(cred.getWebServerConfigId(), cred.getWebServerConfigName(), cred.getSshCredentials()));
        WebServerConfig server = WebServersConfigManager.getInstance((Project)this.myProject).findServer(cred.getWebServerConfigId());
        if (server != null && mySftpServersFilter.value((Object)server)) {
            this.myDeploymentConfigurationsCombo.selectServer(server);
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(server)));
        } else {
            this.myDeploymentConfigurationsCombo.reset(Pair.create((Object)cred.getWebServerConfigId(), (Object)cred.getWebServerConfigName()));
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
            LOG.warn("Can not find selected deployment server: " + cred.getWebServerConfigName());
        }
    }

    public Component getMainPanel() {
        return this.myDeploymentPanel;
    }

    public JLabel getNavigatableLabel() {
        return this.myDeploymentConfigurationLabel;
    }

    public abstract void onDeploymentUpdated(@NotNull WebDeploymentCredentialsHolder var1);

    public abstract void updateCredentials(@Nullable RemoteCredentials var1, @NotNull JLabel var2, @NotNull JLabel var3, @Nullable Runnable var4);

    public WebDeploymentCredentialsHolder getDeploymentCredentials() {
        return this.myDeploymentCredentials;
    }

    public void deploymentSelected() {
        this.useDeploymentSettings(this.myDeploymentConfigurationsCombo.getSelectedServer());
    }

    private void useDeploymentSettings(@Nullable WebServerConfig config) {
        if (config != null) {
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(config)));
            this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(config.getId(), config.getName(), (RemoteCredentials)config.getFileTransferConfig().getCredentials()));
        } else {
            this.setDeploymentCredentials(DEPLOYMENT_EMPTY_CREDENTIALS);
        }
    }

    private void setDeploymentCredentials(WebDeploymentCredentialsHolder deploymentCredentials) {
        this.myDeploymentCredentials = deploymentCredentials;
        this.onDeploymentUpdated(deploymentCredentials);
        this.updateCredentials(this.myDeploymentCredentials.getSshCredentials(), this.myDeploymentHostLabel, this.myDeploymentUrl, null);
    }

    protected void createUIComponents() {
        this.myDeploymentConfigurationsCombo = new WebServerCombo(true, -1, false);
        this.myDeploymentCreateAppLevelSeverLink = new ActionLink("Create", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                WebDeploymentCredentialsHolder credentials = RemoteSdkByDeploymentForm.this.getDeploymentCredentials();
                WebServersConfigManager instance = WebServersConfigManager.getInstance((Project)RemoteSdkByDeploymentForm.this.myProject);
                String webServerConfigId = credentials.getWebServerConfigId();
                WebServerConfig server = instance.findServer(webServerConfigId);
                LOG.assertTrue(server != null, (Object)("Server with id " + webServerConfigId + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"App-level server with actions shown");
                WebServerConfig global = server.clone();
                global.setId(WebServerConfig.getNextId());
                global.setIsProjectLevel(false);
                global.setName("Copy of project-level server '" + global.getName() + "'");
                instance.setUniqueName(global);
                PublishConfig publishConfig = PublishConfig.getInstance((Project)(RemoteSdkByDeploymentForm.this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : RemoteSdkByDeploymentForm.this.myProject));
                List oldPaths = publishConfig.getExcludedPaths(server.getId());
                publishConfig.setExcludedPaths(global.getId(), oldPaths);
                List oldMappings = publishConfig.getPathMappings(server.getId());
                publishConfig.setPathMappings(global.getId(), oldMappings);
                instance.addServer(global);
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(global);
                RemoteSdkByDeploymentForm.this.deploymentSelected();
            }
        });
        this.myDeploymentMoveServerLink = new ActionLink("Move", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                WebDeploymentCredentialsHolder credentials = RemoteSdkByDeploymentForm.this.getDeploymentCredentials();
                WebServersConfigManager instance = WebServersConfigManager.getInstance((Project)RemoteSdkByDeploymentForm.this.myProject);
                WebServerConfig server = instance.findServer(credentials.getWebServerConfigId());
                LOG.assertTrue(server != null, (Object)("Server with id " + credentials.getWebServerConfigId() + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"App-level server with actions shown");
                WebServerConfig movedServer = instance.moveServer(server);
                RemoteSdkByDeploymentForm.this.setupDeploymentCombo(movedServer);
            }
        });
    }

    private void setupDeploymentCombo(@Nullable WebServerConfig configToSelect) {
        if (configToSelect == null) {
            this.myDeploymentConfigurationsCombo.reset(null);
        } else {
            this.myDeploymentConfigurationsCombo.reset(Pair.create((Object)configToSelect.getId(), (Object)configToSelect.getName()));
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateDeployment(configToSelect)));
        }
    }

    @Nullable
    public ValidationInfo validate() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server == null) {
            return new ValidationInfo("Deployment configuration is not selected", (JComponent)this.myDeploymentConfigurationsCombo);
        }
        String deploymentError = this.validateDeployment(server);
        if (StringUtil.isNotEmpty((String)deploymentError)) {
            return new ValidationInfo(deploymentError, (JComponent)this.myDeploymentConfigurationsCombo);
        }
        return null;
    }

    @Nullable
    public String validateDeployment(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/remotesdk/ui/RemoteSdkByDeploymentForm", "validateDeployment"));
        }
        if (server.isProjectLevel()) {
            return "Only application-level servers are currently supported. Please create one using any of the two links above.";
        }
        return null;
    }

    public void updateWarningPanel() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            String error = this.validateDeployment(server);
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(StringUtil.isNotEmpty((String)error));
        }
    }

    public String getValidationError() {
        WebServerConfig server = this.myDeploymentConfigurationsCombo.getSelectedServer();
        if (server != null) {
            return this.validateDeployment(server);
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeploymentConfigurationsCombo;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel3;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel4;
        this.createUIComponents();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentConfigurationLabel = jLabel3 = new JLabel();
        jLabel3.setText("Deployment configuration:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(11);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        WebServerCombo webServerCombo = this.myDeploymentConfigurationsCombo;
        jPanel4.add((Component)webServerCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeploymentHostLabel = jLabel2 = new JLabel();
        jLabel2.setText("Deployment Host URL:");
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentUrl = jLabel = new JLabel();
        jLabel.setText("");
        jPanel6.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentLevelWarningLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Remote SDK is an application-level entity, so it needs the deployment server to be application-level too. Which do you prefer?");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0, 5, 5));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink = this.myDeploymentCreateAppLevelSeverLink;
        actionLink.setText("Create");
        Component component = jPanel8.add((Component)actionLink);
        this.myDeploymentCreateAppLevelLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("application level copy of this deployment server");
        Component component2 = jPanel8.add((Component)jBLabel3);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0, 5, 5));
        jPanel7.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink2 = this.myDeploymentMoveServerLink;
        actionLink2.setText("Move");
        Component component3 = jPanel9.add((Component)actionLink2);
        this.myDeploymentMoveServerLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("this server to application level");
        Component component4 = jPanel9.add((Component)jBLabel2);
        this.myCustomActionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel7.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDeploymentWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("Create SFTP deployment server to configure connection credentials and path mappings.");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }
}

