/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.jam;

import com.intellij.gwt.clientBundle.ClientBundleUtil;
import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssClassNameConverter
extends JamConverter<String> {
    CssClassNameConverter() {
    }

    public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiAnnotation annotation = (PsiAnnotation)context.getParentAnnotationElement().getPsiElement();
        if (annotation == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new CssClassNameReference(literal, new TextRange(1, literal.getTextLength() - 1), psiClass)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class CssClassNameReference
    extends PsiPolyVariantReferenceBase<PsiLiteral> {
        private final PsiClass myPsiClass;

        private CssClassNameReference(PsiLiteral element, TextRange range, PsiClass psiClass) {
            super((PsiElement)element, range, false);
            this.myPsiClass = psiClass;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            Collection classes = this.collectDeclarations().get((Object)this.getValue());
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)classes);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter$CssClassNameReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        private MultiMap<String, CssClass> collectDeclarations() {
            Set<CssFile> files = ClientBundleUtil.getCssFiles(this.myPsiClass, true, true);
            MultiMap declarations = new MultiMap();
            for (CssFile file : files) {
                GwtCssDeclarationsManager.collectDeclarations(file, CssClass.class, declarations);
            }
            return declarations;
        }

        @NotNull
        public Object[] getVariants() {
            Set classes = this.collectDeclarations().keySet();
            Object[] objectArray = ArrayUtil.toStringArray((Collection)classes);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssClassNameConverter$CssClassNameReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

