/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetEditor;
import com.intellij.gwt.packaging.GwtCompileOutputRelativePathSuggester;
import com.intellij.gwt.packaging.GwtCompilerOutputElement;
import com.intellij.gwt.packaging.GwtCompilerOutputElementType;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.util.Processor;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GwtFacetArtifactValidator
extends FacetEditorValidator {
    private final GwtFacet myFacet;
    private final FacetEditorContext myEditorContext;
    private final GwtFacetEditor myGwtFacetEditor;

    public GwtFacetArtifactValidator(GwtFacet facet, FacetEditorContext editorContext, GwtFacetEditor gwtFacetEditor) {
        this.myFacet = facet;
        this.myEditorContext = editorContext;
        this.myGwtFacetEditor = gwtFacetEditor;
    }

    @NotNull
    public ValidationResult check() {
        final ArtifactsStructureConfigurableContext artifactsContext = ((FacetEditorContextBase)this.myEditorContext).getArtifactsStructureContext();
        for (Artifact artifact : artifactsContext.getArtifactModel().getArtifacts()) {
            if (ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)GwtCompilerOutputElementType.getInstance(), (Processor)new Processor<GwtCompilerOutputElement>(){

                public boolean process(GwtCompilerOutputElement element) {
                    return !GwtFacetArtifactValidator.this.myFacet.equals((Object)element.getFacet());
                }
            }, (PackagingElementResolvingContext)artifactsContext, (boolean)false)) continue;
            ArtifactType artifactType = artifact.getArtifactType();
            if (WebArtifactUtil.getInstance().isWebApplication(artifactType) && !this.containsServletJar(artifactsContext, artifact, artifactType) && GwtServletUtil.hasServlets(this.myFacet)) {
                ValidationResult validationResult = new ValidationResult("gwt-servlet.jar is not included in '" + artifact.getName() + "' artifact", (FacetConfigurationQuickFix)new IncludeGwtServletJarQuickFix(artifact, artifactsContext));
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetArtifactValidator", "check"));
                }
                return validationResult;
            }
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetArtifactValidator", "check"));
            }
            return validationResult;
        }
        final ArrayList<? extends Artifact> artifacts = new ArrayList<Artifact>(this.getSuitableArtifacts(artifactsContext));
        Collections.sort(artifacts, ArtifactManager.ARTIFACT_COMPARATOR);
        FacetConfigurationQuickFix fix = artifacts.isEmpty() ? new FacetConfigurationQuickFix("Create Artifact"){

            public void run(JComponent place) {
                GwtFacetArtifactValidator.this.createArtifact(artifactsContext);
            }
        } : new FacetConfigurationQuickFix(){

            public void run(JComponent place) {
                String createItem = "Create Artifact";
                final String includeItem = artifacts.size() == 1 ? "Include into '" + ((Artifact)artifacts.get(0)).getName() + "'" : "Include in artifact";
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, new String[]{"Create Artifact", includeItem}){

                    public boolean hasSubstep(String selectedValue) {
                        return includeItem.equals(selectedValue) && artifacts.size() > 1;
                    }

                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        if (selectedValue.equals("Create Artifact")) {
                            GwtFacetArtifactValidator.this.createArtifact(artifactsContext);
                        } else if (artifacts.size() == 1) {
                            GwtFacetArtifactValidator.this.includeInArtifact((Artifact)artifacts.get(0), artifactsContext);
                        } else {
                            return new MySelectArtifactPopupStep(artifacts, artifactsContext);
                        }
                        return FINAL_CHOICE;
                    }
                }).showUnderneathOf((Component)place);
            }
        };
        ValidationResult validationResult = new ValidationResult("GWT compiler output is not included in an artifact", fix);
        if (validationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetArtifactValidator", "check"));
        }
        return validationResult;
    }

    private boolean containsServletJar(ArtifactsStructureConfigurableContext artifactsContext, Artifact artifact, ArtifactType artifactType) {
        GwtSdk sdk = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk();
        if (!new File(sdk.getServletJarPath()).exists()) {
            return true;
        }
        final String servletJarPath = FileUtil.toSystemIndependentName((String)sdk.getServletJarPath());
        return !ArtifactUtil.processDirectoryChildren((CompositePackagingElement)artifact.getRootElement(), (PackagingElementPath)PackagingElementPath.EMPTY, (String)"/WEB-INF/lib", (PackagingElementResolvingContext)artifactsContext, (ArtifactType)artifactType, (PackagingElementProcessor)new PackagingElementProcessor<PackagingElement<?>>(){

            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/facet/GwtFacetArtifactValidator$4", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/gwt/facet/GwtFacetArtifactValidator$4", "process"));
                }
                return !(element instanceof FileCopyPackagingElement) || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)((FileCopyPackagingElement)element).getFilePath()), (String)servletJarPath);
            }
        });
    }

    private void createArtifact(ArtifactsStructureConfigurableContext artifactsContext) {
        String artifactName = GwtFacetArtifactValidator.suggestArtifactName(this.myFacet.getModule().getName());
        ModifiableArtifact artifact = artifactsContext.getOrCreateModifiableArtifactModel().addArtifact(artifactName, (ArtifactType)PlainArtifactType.getInstance());
        this.includeInArtifact((Artifact)artifact, artifactsContext);
    }

    public static String suggestArtifactName(String moduleName) {
        return moduleName + ":GWT";
    }

    private void includeInArtifact(final Artifact artifact, final ArtifactsStructureConfigurableContext artifactsContext) {
        artifactsContext.editLayout(artifact, new Runnable(){

            @Override
            public void run() {
                GwtCompilerOutputElement element = new GwtCompilerOutputElement(artifactsContext.getProject(), GwtFacetArtifactValidator.this.myFacet);
                String path = GwtCompileOutputRelativePathSuggester.suggestRelativeOutputPath(GwtFacetArtifactValidator.this.myFacet, (PackagingElementResolvingContext)artifactsContext);
                artifactsContext.getRootElement(artifact).addOrFindChild(PackagingElementFactory.getInstance().createParentDirectories(path, (PackagingElement)element));
            }
        });
        ((ArtifactEditorEx)artifactsContext.getOrCreateEditor(artifact)).rebuildTries();
        ProjectStructureConfigurable.getInstance((Project)artifactsContext.getProject()).select(artifact, true);
    }

    private Collection<? extends Artifact> getSuitableArtifacts(ArtifactsStructureConfigurableContext artifactsContext) {
        Collection artifacts;
        WebFacet webFacet;
        String webFacetName = this.myGwtFacetEditor.getSelectedWebFacet();
        if (webFacetName != null && (webFacet = (WebFacet)artifactsContext.getModulesProvider().getFacetModel(this.myFacet.getModule()).findFacet(WebFacet.ID, webFacetName)) != null && !(artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, (PackagingElementResolvingContext)artifactsContext, WebArtifactUtil.getInstance().getWebArtifactTypes(), false)).isEmpty()) {
            return artifacts;
        }
        return artifactsContext.getArtifactModel().getArtifactsByType(WebArtifactUtil.getInstance().getExplodedWarArtifactType());
    }

    private class IncludeGwtServletJarQuickFix
    extends FacetConfigurationQuickFix {
        private final Artifact myArtifact;
        private final ArtifactsStructureConfigurableContext myArtifactsContext;

        public IncludeGwtServletJarQuickFix(Artifact artifact, ArtifactsStructureConfigurableContext artifactsContext) {
            this.myArtifact = artifact;
            this.myArtifactsContext = artifactsContext;
        }

        public void run(JComponent place) {
            this.myArtifactsContext.editLayout(this.myArtifact, new Runnable(){

                @Override
                public void run() {
                    CompositePackagingElement root = IncludeGwtServletJarQuickFix.this.myArtifactsContext.getRootElement(IncludeGwtServletJarQuickFix.this.myArtifact);
                    PackagingElementFactory.getInstance().addFileCopy(root, "WEB-INF/lib", FileUtil.toSystemIndependentName((String)((GwtFacetConfiguration)GwtFacetArtifactValidator.this.myFacet.getConfiguration()).getSdk().getServletJarPath()));
                }
            });
            ((ArtifactEditorEx)this.myArtifactsContext.getOrCreateEditor(this.myArtifact)).rebuildTries();
        }
    }

    private class MySelectArtifactPopupStep
    extends BaseListPopupStep<Artifact> {
        private final ArtifactsStructureConfigurableContext myArtifactsContext;

        public MySelectArtifactPopupStep(List<? extends Artifact> artifacts, ArtifactsStructureConfigurableContext artifactsContext) {
            super("Select Artifact", artifacts);
            this.myArtifactsContext = artifactsContext;
        }

        @NotNull
        public String getTextFor(Artifact value) {
            String string = value.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetArtifactValidator$MySelectArtifactPopupStep", "getTextFor"));
            }
            return string;
        }

        public Icon getIconFor(Artifact aValue) {
            return aValue.getArtifactType().getIcon();
        }

        public PopupStep onChosen(Artifact selectedValue, boolean finalChoice) {
            GwtFacetArtifactValidator.this.includeInArtifact(selectedValue, this.myArtifactsContext);
            return FINAL_CHOICE;
        }
    }
}

