/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.AbstractClientCodeReferencesInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClientClassFromNonInheritedModuleUsageInspection
extends AbstractClientCodeReferencesInspection {
    @Override
    protected void checkClassReference(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiClass referencedClass, @NotNull String className, @NotNull VirtualFile virtualFile, @NotNull GwtFacet gwtFacet, List<GwtModule> gwtModules, @NotNull GwtModulesManager gwtModulesManager, @NotNull InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (referencedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedClass", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (gwtFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtFacet", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (gwtModulesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModulesManager", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "checkClassReference"));
        }
        List<GwtModule> referencedModules = gwtModulesManager.findGwtModulesByClientSourceFile(virtualFile);
        if (referencedModules.isEmpty()) {
            referencedModules = gwtModulesManager.findModulesByClass((PsiElement)reference, referencedClass.getQualifiedName());
        }
        if (referencedModules.isEmpty()) {
            return;
        }
        for (GwtModule gwtModule : gwtModules) {
            if (gwtModulesManager.isLibraryModule(gwtModule) || gwtModulesManager.isInheritedOrSelf(gwtModule, referencedModules) || ClientClassFromNonInheritedModuleUsageInspection.isImplicitlyInheritedInTest(reference, referencedModules, gwtModulesManager)) continue;
            GwtModule referencedModule = referencedModules.get(0);
            String message = GwtBundle.message("problem.description.class.0.is.defined.in.module.1.which.is.not.inherited.in.module.2", className, referencedModule.getQualifiedName(), gwtModule.getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, (LocalQuickFix)new InheritModuleQuickFix(gwtModule, referencedModule), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            return;
        }
    }

    private static boolean isImplicitlyInheritedInTest(PsiJavaCodeReferenceElement reference, List<GwtModule> referencesModules, GwtModulesManager gwtModulesManager) {
        if (!ClientClassFromNonInheritedModuleUsageInspection.isInGwtTestCase(reference)) {
            return false;
        }
        GwtModule junitModule = gwtModulesManager.findGwtModuleByQualifiedName("com.google.gwt.junit.JUnit", reference.getResolveScope());
        return junitModule != null && gwtModulesManager.isInheritedOrSelf(junitModule, referencesModules);
    }

    private static boolean isInGwtTestCase(PsiJavaCodeReferenceElement reference) {
        PsiFile containingFile = reference.getContainingFile();
        VirtualFile file = containingFile.getVirtualFile();
        Project project = reference.getProject();
        if (file == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(file)) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiClass[] classes = ((PsiJavaFile)containingFile).getClasses();
        if (classes.length != 1) {
            return false;
        }
        PsiClass psiClass = classes[0];
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"com.google.gwt.junit.client.GWTTestCase");
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.client.class.from.non.inherited.module.usage", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtClientClassFromNonInheritedModule" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection", "getShortName"));
        }
        return "GwtClientClassFromNonInheritedModule";
    }

    private static class InheritModuleQuickFix
    extends BaseGwtLocalQuickFix {
        private final GwtModule myGwtModule;
        private final GwtModule myReferencedModule;

        public InheritModuleQuickFix(GwtModule gwtModule, GwtModule referencedModule) {
            super(GwtBundle.message("quick.fix.name.inherit.module.0.from.1", gwtModule.getQualifiedName(), referencedModule.getQualifiedName()));
            this.myGwtModule = gwtModule;
            this.myReferencedModule = referencedModule;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection$InheritModuleQuickFix", "applyFix"));
            }
            if (problemDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection$InheritModuleQuickFix", "applyFix"));
            }
            if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{this.myGwtModule.getModuleFile()}).hasReadonlyFiles()) {
                this.myGwtModule.addInherits().getName().setValue((Object)this.myReferencedModule.getQualifiedName());
            }
        }
    }
}

