/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtRelativePath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtDefaultPackageNotRegisteredInspection
extends BaseGwtInspection {
    @NonNls
    private static final String SOURCE_TAG = "source";

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "checkFile"));
        }
        if (!GwtDefaultPackageNotRegisteredInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        if (!file.getName().endsWith(".gwt.xml")) {
            return null;
        }
        GwtModule gwtModule = GwtModulesManager.getInstance(file.getProject()).getGwtModule(file);
        if (gwtModule == null) {
            return null;
        }
        SmartList problems = new SmartList();
        List<GwtRelativePath> sources = gwtModule.getSources();
        List<GwtRelativePath> superSources = gwtModule.getSuperSources();
        GwtDefaultPackageNotRegisteredInspection.checkSubPackageWithDefaultNameRegistered(SOURCE_TAG, "client", sources, superSources, gwtModule, file, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        List<GwtRelativePath> publics = gwtModule.getPublics();
        GwtDefaultPackageNotRegisteredInspection.checkSubPackageWithDefaultNameRegistered("public", "public", publics, Collections.emptyList(), gwtModule, file, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkSubPackageWithDefaultNameRegistered(String tagName, String defaultPath, List<GwtRelativePath> paths, List<GwtRelativePath> additionalPaths, GwtModule gwtModule, PsiFile file, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (!(paths.isEmpty() && additionalPaths.isEmpty() || GwtDefaultPackageNotRegisteredInspection.containsPath(paths, defaultPath) || GwtDefaultPackageNotRegisteredInspection.containsPath(additionalPaths, defaultPath) || !GwtDefaultPackageNotRegisteredInspection.hasSubPackage(file, defaultPath))) {
            AddPathTagQuickFix fix = new AddPathTagQuickFix(gwtModule, tagName, defaultPath);
            String message = "'" + defaultPath + "' subpackage is not registered as " + tagName + " path in '" + file.getName() + "'";
            GwtRelativePath item = (GwtRelativePath)ContainerUtil.getFirstItem(paths, null);
            if (item == null) {
                item = (GwtRelativePath)ContainerUtil.getFirstItem(additionalPaths, null);
            }
            if (item == null) {
                return;
            }
            problems.add(manager.createProblemDescriptor((PsiElement)item.getXmlTag(), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    private static boolean hasSubPackage(@NotNull PsiFile file, @NotNull String name) {
        PsiPackage[] subPackages;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "hasSubPackage"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "hasSubPackage"));
        }
        PsiDirectory directory = file.getContainingDirectory();
        if (directory == null) {
            return false;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return false;
        }
        for (PsiPackage subPackage : subPackages = aPackage.getSubPackages(file.getResolveScope())) {
            if (!name.equals(subPackage.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsPath(List<GwtRelativePath> paths, String path) {
        for (GwtRelativePath relativePath : paths) {
            if (!path.equals(relativePath.getPath().getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'client' package or 'public' directory is not registered in gwt.xml file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "getDisplayName"));
        }
        return "'client' package or 'public' directory is not registered in gwt.xml file";
    }

    @NotNull
    public String getShortName() {
        if ("GwtDefaultPackageNotRegistered" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection", "getShortName"));
        }
        return "GwtDefaultPackageNotRegistered";
    }

    private static class AddPathTagQuickFix
    extends BaseGwtLocalQuickFix {
        private final GwtModule myGwtModule;
        private final String myTagName;
        private final String myPackageName;

        private AddPathTagQuickFix(GwtModule gwtModule, String tagName, String packageName) {
            super("Register '" + packageName + "' subpackage as " + tagName + " path");
            this.myGwtModule = gwtModule;
            this.myTagName = tagName;
            this.myPackageName = packageName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection$AddPathTagQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection$AddPathTagQuickFix", "applyFix"));
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.myGwtModule.getModuleXmlFile())) {
                return;
            }
            GwtRelativePath path = this.myTagName.equals(GwtDefaultPackageNotRegisteredInspection.SOURCE_TAG) ? this.myGwtModule.addSource() : this.myGwtModule.addPublic();
            path.getPath().setStringValue(this.myPackageName);
        }
    }
}

