/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtInconsistentAsyncInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtInconsistentAsyncInterfaceInspection");

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtInconsistentAsyncInterfaceInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null) {
            return null;
        }
        GwtVersion gwtVersion = gwtFacet.getSdkVersion();
        if (RemoteServiceUtil.isRemoteServiceInterface(aClass)) {
            return GwtInconsistentAsyncInterfaceInspection.checkRemoteServiceForAsync(aClass, gwtVersion, manager, isOnTheFly);
        }
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(aClass);
        if (sync != null) {
            return GwtInconsistentAsyncInterfaceInspection.checkAsyncServiceForRemote(sync, aClass, gwtVersion, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor[] checkAsyncServiceForRemote(PsiClass sync, PsiClass async, GwtVersion gwtVersion, InspectionManager manager, boolean onTheFly) {
        SmartList problems = new SmartList();
        SmartList methodsToCopy = new SmartList();
        for (PsiMethod method : sync.getMethods()) {
            if (RemoteServiceUtil.isMethodPresentedInAsync(method, async)) continue;
            methodsToCopy.add(method);
        }
        for (PsiMethod asyncMethod : async.getMethods()) {
            PsiType returnType;
            if (!RemoteServiceUtil.isMethodPresentedInSync(asyncMethod, sync)) {
                String message = GwtBundle.message("problem.description.async.method.does.not.have.sync.variant", asyncMethod.getName());
                CopyMethodToSyncQuickFix quickFix = new CopyMethodToSyncQuickFix(asyncMethod, sync);
                problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(asyncMethod), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }
            if ((returnType = asyncMethod.getReturnType()) != null && (returnType.equals(PsiType.VOID) || returnType.getCanonicalText().equals("com.google.gwt.http.client.Request") || returnType.getCanonicalText().equals("com.google.gwt.http.client.RequestBuilder"))) continue;
            String message = GwtBundle.message("problem.description.the.asynchronous.version.of.method.0.must.have.a.return.type.void", asyncMethod.getName());
            MakeMethodReturnVoid fix = new MakeMethodReturnVoid(asyncMethod);
            problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(asyncMethod), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        if (!methodsToCopy.isEmpty()) {
            String message = GwtBundle.message("problem.description.methods.of.async.remote.service.0.isn.t.synchronized.with.1", async.getName(), sync.getName());
            ArrayList<BaseGwtLocalQuickFix> quickFixesList = new ArrayList<BaseGwtLocalQuickFix>();
            for (PsiMethod method : methodsToCopy) {
                quickFixesList.add(new CopyMethodToAsyncQuickFix(async, method, gwtVersion));
            }
            quickFixesList.add(new SynchronizeAllMethodsInAsyncQuickFix(async, sync, gwtVersion));
            LocalQuickFix[] fixes = quickFixesList.toArray(new LocalQuickFix[quickFixesList.size()]);
            problems.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(async), message, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static ProblemDescriptor[] checkRemoteServiceForAsync(PsiClass aClass, GwtVersion gwtVersion, InspectionManager manager, boolean onTheFly) {
        GlobalSearchScope scope = aClass.getResolveScope();
        PsiClass async = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(aClass.getQualifiedName() + "Async", scope);
        if (async == null) {
            String description = GwtBundle.message("problem.description.remote.service.0.does.not.have.corresponding.async.variant", aClass.getName());
            return new ProblemDescriptor[]{manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(aClass), description, (LocalQuickFix)new CreateAsyncClassQuickFix(aClass, gwtVersion), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly)};
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>(0);
        for (PsiMethod method : aClass.getMethods()) {
            if (RemoteServiceUtil.isMethodPresentedInAsync(method, async)) continue;
            CopyMethodToAsyncQuickFix fix = new CopyMethodToAsyncQuickFix(async, method, gwtVersion);
            String message = GwtBundle.message("problem.description.async.remote.service.0.does.not.define.corresponding.method", async.getName());
            result.add(manager.createProblemDescriptor(GwtInconsistentAsyncInterfaceInspection.getElementToHighlight(method), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.inconsistent.gwt.remote.service", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GWTRemoteServiceAsyncCheck" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection", "getShortName"));
        }
        return "GWTRemoteServiceAsyncCheck";
    }

    private static class CreateAsyncClassQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiClass myRemoteServiceInterface;
        private final GwtVersion myGwtVersion;

        public CreateAsyncClassQuickFix(PsiClass remoteServiceInterface, GwtVersion gwtVersion) {
            super(GwtBundle.message("quick.fix.name.create.interface.0", remoteServiceInterface.getName()) + "Async");
            this.myRemoteServiceInterface = remoteServiceInterface;
            this.myGwtVersion = gwtVersion;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CreateAsyncClassQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CreateAsyncClassQuickFix", "applyFix"));
            }
            try {
                PsiJavaFile classFile = (PsiJavaFile)this.myRemoteServiceInterface.getContainingFile();
                LOG.assertTrue(classFile != null);
                String name = this.myRemoteServiceInterface.getName() + "Async";
                PsiTypeParameterList typeParameterList = this.myRemoteServiceInterface.getTypeParameterList();
                PsiPackageStatement packageStatement = classFile.getPackageStatement();
                StringBuilder source = new StringBuilder();
                source.append(packageStatement != null ? packageStatement.getText() : "").append("\n\n");
                PsiImportList psiImportList = classFile.getImportList();
                source.append(psiImportList != null ? psiImportList.getText() : "");
                source.append("public interface ").append(name);
                if (typeParameterList != null) {
                    source.append(typeParameterList.getText());
                }
                source.append("\n{\n}\n");
                PsiJavaFile asyncFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(name + ".java", source.toString());
                PsiClass async = asyncFile.getClasses()[0];
                RemoteServiceUtil.copyAllMethodsToAsync(this.myRemoteServiceInterface, async, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)asyncFile);
                PsiDirectory directory = classFile.getContainingDirectory();
                LOG.assertTrue(directory != null);
                directory.add((PsiElement)asyncFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static class SynchronizeAllMethodsInAsyncQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiClass myAsync;
        private final PsiClass myRemoteServiceInterface;
        private final GwtVersion myGwtVersion;

        public SynchronizeAllMethodsInAsyncQuickFix(PsiClass async, PsiClass remoteServiceInterface, GwtVersion gwtVersion) {
            super(GwtBundle.message("quick.fix.name.synchronize.all.methods.of.0.with.1", async.getName(), remoteServiceInterface.getName()));
            this.myAsync = async;
            this.myRemoteServiceInterface = remoteServiceInterface;
            this.myGwtVersion = gwtVersion;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$SynchronizeAllMethodsInAsyncQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$SynchronizeAllMethodsInAsyncQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myAsync.getContainingFile())) {
                return;
            }
            try {
                RemoteServiceUtil.copyAllMethodsToAsync(this.myRemoteServiceInterface, this.myAsync, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)this.myAsync);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static class CopyMethodToAsyncQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiClass myAsync;
        private final PsiMethod myMethod;
        private final GwtVersion myGwtVersion;

        private CopyMethodToAsyncQuickFix(PsiClass async, PsiMethod method, GwtVersion gwtVersion) {
            super(GwtBundle.message("quick.fix.name.copy.method.to.async", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.myAsync = async;
            this.myMethod = method;
            this.myGwtVersion = gwtVersion;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToAsyncQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToAsyncQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myAsync.getContainingFile())) {
                return;
            }
            try {
                PsiMethod newMethod = RemoteServiceUtil.copyMethodToAsync(this.myMethod, this.myAsync, this.myGwtVersion);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newMethod);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static class MakeMethodReturnVoid
    extends BaseGwtLocalQuickFix {
        private final PsiMethod myMethod;

        public MakeMethodReturnVoid(PsiMethod method) {
            super(GwtBundle.message("quickfix.name.make.0.return.void", method.getName()));
            this.myMethod = method;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$MakeMethodReturnVoid", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$MakeMethodReturnVoid", "applyFix"));
            }
            PsiTypeElement returnTypeElement = this.myMethod.getReturnTypeElement();
            if (returnTypeElement != null) {
                returnTypeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)PsiType.VOID));
            }
        }
    }

    private static class CopyMethodToSyncQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiClass mySync;
        private final PsiMethod myMethod;

        private CopyMethodToSyncQuickFix(PsiMethod method, PsiClass sync) {
            super(GwtBundle.message("quick.fix.name.create.sync.method.for.async", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.mySync = sync;
            this.myMethod = method;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToSyncQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtInconsistentAsyncInterfaceInspection$CopyMethodToSyncQuickFix", "applyFix"));
            }
            VirtualFile file = this.mySync.getContainingFile().getVirtualFile();
            if (file == null || ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file}).hasReadonlyFiles()) {
                return;
            }
            try {
                PsiMethod method = RemoteServiceUtil.copyMethodToSync(this.myMethod, this.mySync);
                PsiElement reformatted = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
                OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, file);
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(fileDescriptor, true);
                if (editor != null) {
                    PsiTypeElement returnTypeElement;
                    editor.getCaretModel().moveToOffset(reformatted.getTextRange().getStartOffset());
                    if (reformatted instanceof PsiMethod && (returnTypeElement = ((PsiMethod)reformatted).getReturnTypeElement()) != null) {
                        TextRange typeRange = returnTypeElement.getTextRange();
                        editor.getSelectionModel().setSelection(typeRange.getStartOffset(), typeRange.getEndOffset());
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

