/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseJavaFromJSReferenceInspection;
import com.intellij.gwt.jsinject.GwtClassMemberReference;
import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtJavaScriptReferencesInspection
extends BaseJavaFromJSReferenceInspection {
    @Override
    protected void checkReferenceExpression(JSGwtReferenceExpressionImpl element, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        PsiReference[] references;
        for (PsiReference reference : references = element.getReferences()) {
            if (reference.resolve() != null) continue;
            if (reference instanceof GwtClassMemberReference) {
                String message;
                GwtClassMemberReference gwtReference = (GwtClassMemberReference)reference;
                PsiClass psiClass = gwtReference.resolveQualifier();
                if (psiClass == null) continue;
                ResolveResult[] results = gwtReference.multiResolve(false);
                if (results.length > 1) {
                    String method1String = GwtJavaScriptReferencesInspection.formatMethod((PsiMethod)results[0].getElement());
                    String method2String = GwtJavaScriptReferencesInspection.formatMethod((PsiMethod)results[1].getElement());
                    message = GwtBundle.message("problem.description.ambiguous.wildcard.match", method1String, method2String, psiClass.getQualifiedName(), reference.getCanonicalText());
                } else {
                    message = GwtBundle.message("problem.description.cannot.resolve.symbol.0.in.1", reference.getCanonicalText(), psiClass.getQualifiedName());
                }
                problems.add(manager.createProblemDescriptor((PsiElement)element, reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
                continue;
            }
            String message = GwtBundle.message("problem.description.cannot.resolve.0", reference.getCanonicalText());
            problems.add(manager.createProblemDescriptor((PsiElement)element, reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
    }

    @NotNull
    private static String formatMethod(PsiMethod method1) {
        String string = PsiFormatUtil.formatMethod((PsiMethod)method1, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtJavaScriptReferencesInspection", "formatMethod"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.unresolved.references.in.jsni.methods", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtJavaScriptReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtJavaScriptReferences" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtJavaScriptReferencesInspection", "getShortName"));
        }
        return "GwtJavaScriptReferences";
    }
}

