/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.junit;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.facet.FacetManager;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.run.GwtClasspathUtil;
import com.intellij.gwt.runtime.GwtTestsRunner;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GwtJUnitPatcher
extends JUnitPatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.junit.GwtJUnitPatcher");
    @NonNls
    private static final String GWT_ARGS_PROPERTY = "gwt.args";

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        File webXml;
        ConfigFile webXmlDescriptor;
        WebFacet webFacet;
        if (module == null) {
            return;
        }
        GwtFacet facet = (GwtFacet)FacetManager.getInstance((Module)module).getFacetByType(GwtFacetType.ID);
        if (facet == null) {
            return;
        }
        Project project = module.getProject();
        if (GwtModulesManager.getInstance(project).getGwtModules(module, true).isEmpty()) {
            return;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass("com.google.gwt.junit.client.GWTTestCase", module.getModuleWithDependenciesAndLibrariesScope(true));
        if (baseClass == null) {
            LOG.debug("com.google.gwt.junit.client.GWTTestCase class not found");
            return;
        }
        if (ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)module.getModuleScope(), (boolean)true).findFirst() == null) {
            LOG.debug("GWTTestCase inheritors not found in " + module.getName());
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        PathsList sources = GwtClasspathUtil.getSourceRootsOfGwtModules(module, false);
        ArrayList<String> ignoredUrls = new ArrayList<String>();
        for (String path : sources.getPathList()) {
            classPath.addFirst(path);
            File file = new File(path, "META-INF" + File.separator + "jdoconfig.xml");
            if (!file.exists()) continue;
            try {
                ignoredUrls.add(file.toURI().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        classPath.addFirst(((GwtFacetConfiguration)facet.getConfiguration()).getSdk().getDevJarPath());
        javaParameters.setUseClasspathJar(false);
        if (!ignoredUrls.isEmpty()) {
            LOG.debug(ignoredUrls.size() + " files will be excluded from classpath:");
            for (String ignoredUrl : ignoredUrls) {
                LOG.debug(" " + ignoredUrl);
            }
            try {
                GwtJUnitPatcher.configureGwtTestsClassLoader(javaParameters, classPath, ignoredUrls);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        GwtVersion sdkVersion = facet.getSdkVersion();
        ParametersList vmParameters = javaParameters.getVMParametersList();
        StringBuilder builder = new StringBuilder();
        String gwtArgs = vmParameters.getPropertyValue(GWT_ARGS_PROPERTY);
        boolean haveGenOption = false;
        boolean haveOutOption = false;
        if (gwtArgs != null) {
            String unquoted = StringUtil.unquoteString((String)gwtArgs);
            List existingOptions = StringUtil.splitHonorQuotes((String)unquoted, (char)' ');
            haveGenOption = existingOptions.contains("-gen");
            haveOutOption = existingOptions.contains(sdkVersion.getCompilerOutputDirParameterName());
            builder.append(unquoted).append(' ');
        }
        String testGenPath = GwtCompilerPaths.getTestGenDirectory(module).getAbsolutePath();
        String testOutputPath = GwtCompilerPaths.getTestOutputDirectory(module).getAbsolutePath();
        if (sdkVersion.isHostedModeRequiresWebXml() && !haveOutOption && (webFacet = facet.getWebFacet()) != null && (webXmlDescriptor = webFacet.getWebXmlDescriptor()) != null && (webXml = new File(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)webXmlDescriptor.getUrl())))).exists()) {
            try {
                FileUtil.copy((File)webXml, (File)new File(testOutputPath, "WEB-INF" + File.separator + "web.xml"));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if (!haveGenOption) {
            builder.append("-gen \"").append(testGenPath).append("\" ");
        }
        if (!haveOutOption) {
            builder.append(sdkVersion.getCompilerOutputDirParameterName()).append(" \"").append(testOutputPath).append('\"');
        }
        String prefix = "-Dgwt.args=";
        vmParameters.replaceOrAppend(prefix, prefix + builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureGwtTestsClassLoader(JavaParameters javaParameters, PathsList classPath, List<String> ignoredUrls) throws IOException {
        classPath.addFirst(PathUtil.getJarPathForClass(GwtTestsRunner.class));
        String mainClass = javaParameters.getMainClass();
        ParametersList programParameters = javaParameters.getProgramParametersList();
        File file = FileUtil.createTempFile((String)"gwtTestsClassLoaderIgnoredUrls", (String)".txt");
        try (PrintWriter writer = new PrintWriter(file);){
            for (String url : ignoredUrls) {
                writer.println(url);
            }
        }
        programParameters.addAt(0, mainClass);
        programParameters.addAt(1, file.getAbsolutePath());
        javaParameters.setMainClass(GwtTestsRunner.class.getName());
    }
}

