/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.make.GwtBuilderMessageHandler;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.index.impl.JpsGwtModulesCache;

public class GwtModulesIndexBuildTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance(GwtModulesIndexBuildTask.class);
    private final Project myProject;

    public GwtModulesIndexBuildTask(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtModulesIndexBuildTask", "<init>"));
        }
        this.myProject = project;
    }

    public boolean execute(CompileContext context) {
        if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(GwtFacetType.ID)) {
            GwtBuilderMessageHandler.getInstance(this.myProject).installExternalGwtBuilderListener();
            new ReadAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/make/GwtModulesIndexBuildTask$1", "run"));
                    }
                    File projectSystemDirectory = BuildManager.getInstance().getProjectSystemDirectory(GwtModulesIndexBuildTask.this.myProject);
                    JpsGwtModulesCache cache = new JpsGwtModulesCache(projectSystemDirectory);
                    if (DumbService.isDumb((Project)GwtModulesIndexBuildTask.this.myProject)) {
                        LOG.debug("Indices aren't available, clearing GWT modules cache");
                        cache.clear();
                    } else {
                        Collection<VirtualFile> files = GwtModulesManager.getInstance(GwtModulesIndexBuildTask.this.myProject).getGwtModuleFiles(GlobalSearchScope.projectScope((Project)GwtModulesIndexBuildTask.this.myProject));
                        LOG.debug("Creating GWT modules cache for " + files.size() + " *.gwt.xml files");
                        JpsGwtModulesCache.GwtModulesConfiguration modulesConfiguration = new JpsGwtModulesCache.GwtModulesConfiguration();
                        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)GwtModulesIndexBuildTask.this.myProject).getFileIndex();
                        for (VirtualFile file : files) {
                            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
                            Module module = fileIndex.getModuleForFile(file);
                            if (sourceRoot == null || module == null) continue;
                            boolean inTests = fileIndex.isInTestSourceContent(file);
                            modulesConfiguration.myGwtModules.add(new JpsGwtModulesCache.GwtModuleData(file.getPath(), sourceRoot.getPath(), inTests, module.getName()));
                        }
                        cache.saveGwtModules(modulesConfiguration);
                    }
                }
            }.execute();
        }
        return true;
    }
}

