/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.GwtHtmlElementClassesFinder;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UiBinderUtil {
    @NonNls
    public static final String UI_XML_SUFFIX = ".ui.xml";
    @NonNls
    public static final String ELEMENT_BASE_CLASS = "com.google.gwt.dom.client.Element";
    @NonNls
    public static final String WIDGET_BASE_CLASS = "com.google.gwt.user.client.ui.IsWidget";
    @NonNls
    public static final String WIDGET_CLASS = "com.google.gwt.user.client.ui.Widget";
    @NonNls
    public static final String URN_IMPORT_PREFIX = "urn:import:";
    @NonNls
    public static final String UI_BINDER_NAMESPACE = "urn:ui:com.google.gwt.uibinder";
    @NonNls
    public static final String UI_FIELD_ATTRIBUTE = "field";
    @NonNls
    public static final String UI_WITH_TAG = "with";
    @NonNls
    public static final String UI_TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String UI_CONSTRUCTOR_ANNOTATION = "com.google.gwt.uibinder.client.UiConstructor";
    @NonNls
    public static final String UI_FIELD_ANNOTATION = "com.google.gwt.uibinder.client.UiField";
    @NonNls
    public static final String UI_HANDLER_ANNOTATION = "com.google.gwt.uibinder.client.UiHandler";
    @NonNls
    public static final String UI_FACTORY_ANNOTATION = "com.google.gwt.uibinder.client.UiFactory";
    @NonNls
    public static final String UI_CHILD_ANNOTATION = "com.google.gwt.uibinder.client.UiChild";
    @NonNls
    public static final String RESOURCE_PROTOTYPE_CLASS = "com.google.gwt.resources.client.ResourcePrototype";
    @NonNls
    public static final String GWT_EVENT_CLASS = "com.google.gwt.event.shared.GwtEvent";
    @NonNls
    public static final String HANDLER_REGISTRATION_INTERFACE = "com.google.gwt.event.shared.HandlerRegistration";
    @NonNls
    public static final String UI_STYLE_TAG = "style";
    @NonNls
    public static final String PROVIDED_ANNOTATION_ATTRIBUTE = "provided";
    @NonNls
    public static final String LAZY_DOM_ELEMENT_CLASS_NAME = "com.google.gwt.uibinder.client.LazyDomElement";
    @NonNls
    public static final String UI_BINDER_INTERFACE = "com.google.gwt.uibinder.client.UiBinder";
    @NonNls
    public static final String UI_RENDERER_INTERFACE = "com.google.gwt.uibinder.client.UiRenderer";
    @NonNls
    public static final String UI_TEMPLATE_ANNOTATION = "com.google.gwt.uibinder.client.UiTemplate";

    private UiBinderUtil() {
    }

    public static boolean isUiXmlFile(XmlFile file) {
        return file.getName().endsWith(UI_XML_SUFFIX);
    }

    public static boolean isUiHandlerMethod(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        return ((PsiMethod)element).getModifierList().findAnnotation(UI_HANDLER_ANNOTATION) != null;
    }

    public static boolean isUiFactoryMethod(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        return ((PsiMethod)element).getModifierList().findAnnotation(UI_FACTORY_ANNOTATION) != null;
    }

    public static boolean isUiField(PsiField field) {
        PsiModifierList modifierList = field.getModifierList();
        return modifierList != null && modifierList.findAnnotation(UI_FIELD_ANNOTATION) != null;
    }

    @NotNull
    public static String getComponentClassName(XmlTag tag) {
        String value;
        XmlAttribute typeAttribute = tag.getAttribute(UI_TYPE_ATTRIBUTE, UI_BINDER_NAMESPACE);
        if (typeAttribute == null && tag.getNamespace().equals(UI_BINDER_NAMESPACE)) {
            typeAttribute = tag.getAttribute(UI_TYPE_ATTRIBUTE);
        }
        if (typeAttribute != null && (value = typeAttribute.getValue()) != null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/UiBinderUtil", "getComponentClassName"));
            }
            return string;
        }
        String className = null;
        String namespace = tag.getNamespace();
        String tagName = tag.getLocalName();
        if (namespace.startsWith(URN_IMPORT_PREFIX)) {
            String packageName = namespace.substring(URN_IMPORT_PREFIX.length());
            className = StringUtil.getQualifiedName((String)packageName, (String)tagName);
        } else {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)tag);
            if (module != null) {
                className = GwtHtmlElementClassesFinder.findElementClass(tagName, module);
            }
        }
        String string = className != null ? className : ELEMENT_BASE_CLASS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/UiBinderUtil", "getComponentClassName"));
        }
        return string;
    }

    public static boolean hasUiBinderNamespace(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/gwt/uiBinder/UiBinderUtil", "hasUiBinderNamespace"));
        }
        String namespace = attribute.getNamespace();
        XmlTag parent = attribute.getParent();
        return namespace.equals(UI_BINDER_NAMESPACE) || namespace.length() == 0 && parent != null && parent.getNamespace().equals(UI_BINDER_NAMESPACE);
    }

    public static boolean isProvidedUiField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", UI_FIELD_ATTRIBUTE, "com/intellij/gwt/uiBinder/UiBinderUtil", "isProvidedUiField"));
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return false;
        }
        PsiAnnotation annotation = modifierList.findAnnotation(UI_FIELD_ANNOTATION);
        if (annotation == null) {
            return false;
        }
        Boolean value = (Boolean)AnnotationModelUtil.getBooleanValue((PsiAnnotation)annotation, (String)PROVIDED_ANNOTATION_ATTRIBUTE, (boolean)false).getValue();
        return Boolean.TRUE.equals(value);
    }

    public static boolean isImplementationProvidedByGwt(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/uiBinder/UiBinderUtil", "isImplementationProvidedByGwt"));
        }
        if (!psiClass.isInterface()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)UI_BINDER_INTERFACE) || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)UI_RENDERER_INTERFACE);
    }

    @NotNull
    public static PsiType getUnwrappedUiFieldType(@NotNull PsiField field) {
        PsiType[] typeParameters;
        PsiClassType classType;
        PsiClassType.ClassResolveResult resolved;
        PsiClass psiClass;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", UI_FIELD_ATTRIBUTE, "com/intellij/gwt/uiBinder/UiBinderUtil", "getUnwrappedUiFieldType"));
        }
        PsiType fieldType = field.getType();
        if (fieldType instanceof PsiClassType && (psiClass = (resolved = (classType = (PsiClassType)fieldType).resolveGenerics()).getElement()) != null && LAZY_DOM_ELEMENT_CLASS_NAME.equals(psiClass.getQualifiedName()) && (typeParameters = classType.getParameters()).length == 1) {
            PsiType psiType = typeParameters[0];
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/UiBinderUtil", "getUnwrappedUiFieldType"));
            }
            return psiType;
        }
        PsiType psiType = fieldType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/UiBinderUtil", "getUnwrappedUiFieldType"));
        }
        return psiType;
    }
}

