/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.declarations;

import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclarationImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiStyleElement
extends UiXmlVariableDeclarationImpl {
    @NonNls
    public static final String SRC_ATTRIBUTE = "src";
    @NonNls
    public static final String DEFAULT_FIELD_NAME = "style";

    UiStyleElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiStyleElement", "<init>"));
        }
        super(tag, DEFAULT_FIELD_NAME);
    }

    public MultiMap<String, CssClass> collectCssDeclarations() {
        MultiMap declarations = new MultiMap();
        CssFile externalFile = this.findExternalFile();
        if (externalFile != null) {
            GwtCssDeclarationsManager.collectDeclarations(externalFile, CssClass.class, declarations);
        }
        for (XmlText text : this.myTag.getValue().getTextElements()) {
            List pairs = InjectedLanguageManager.getInstance((Project)text.getProject()).getInjectedPsiFiles((PsiElement)text);
            if (pairs == null) continue;
            for (Pair pair : pairs) {
                PsiElement injected = (PsiElement)pair.getFirst();
                if (!(injected instanceof CssFile)) continue;
                GwtCssDeclarationsManager.collectDeclarations((CssFile)injected, CssClass.class, declarations);
            }
        }
        return declarations;
    }

    @Nullable
    private CssFile findExternalFile() {
        String cssFilePath = this.myTag.getAttributeValue(SRC_ATTRIBUTE);
        VirtualFile xmlFile = this.myTag.getContainingFile().getOriginalFile().getVirtualFile();
        if (xmlFile == null || cssFilePath == null) {
            return null;
        }
        VirtualFile cssFile = xmlFile.getParent().findFileByRelativePath(cssFilePath);
        if (cssFile == null) {
            return null;
        }
        PsiFile psiFile = this.myTag.getManager().findFile(cssFile);
        return psiFile instanceof CssFile ? (CssFile)psiFile : null;
    }

    @Nullable
    public CssFile getCssFile() {
        CssFile file = this.findExternalFile();
        if (file != null) {
            return file;
        }
        for (XmlText text : this.myTag.getValue().getTextElements()) {
            List pairs = InjectedLanguageManager.getInstance((Project)text.getProject()).getInjectedPsiFiles((PsiElement)text);
            if (pairs == null) continue;
            for (Pair pair : pairs) {
                if (!(pair.getFirst() instanceof CssFile)) continue;
                return (CssFile)pair.getFirst();
            }
        }
        return null;
    }
}

