/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerEmbedded;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerManual;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianGlassfishEmbedded_3_1;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianJBossEmbedded_6_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianJettyEmbedded_6_1_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianJettyEmbedded_7and8_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianJettyEmbedded_9_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOSGiContainerEquinoxEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOSGiContainerFelixEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOSGiContainerJBossEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOSGiContainerKarafEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOpenEJB;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianOpenWebBeansEmbedded_1_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianResinEmbedded_4;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianTomEEEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianTomcatEmbedded_6_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianTomcatEmbedded_7_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianTomcatEmbedded_8_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianUndertowEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWebLogicEmbedded_12_1;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWebSphereASEmbedded_8_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWeldEEEmbedded_1_1_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWeldSEEmbedded_1_1_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWeldSEEmbedded_1_x;
import com.intellij.plugins.jboss.arquillian.libraries.ArquillianWildFlyEmbedded;
import com.intellij.plugins.jboss.arquillian.libraries.SimpleLoggingFacadeForJava;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianContainersAppManager {
    @NotNull
    private final List<ArquillianContainer> manualContainers = ArquillianContainersAppManager.createManualContainers();
    @NotNull
    private final List<ArquillianContainer> embeddedContainers = ArquillianContainersAppManager.createEmbeddedContainers();
    @NotNull
    private final List<ArquillianContainer> managedContainers = ArquillianContainersAppManager.createManagedContainers();
    @NotNull
    private final List<ArquillianContainer> remoteContainers = ArquillianContainersAppManager.createRemoteContainers();
    private Map<String, ArquillianContainer> registeredContainers = Maps.uniqueIndex((Iterable)Iterables.concat(this.manualContainers, this.embeddedContainers, this.managedContainers, this.remoteContainers), (Function)new Function<ArquillianContainer, String>(){

        public String apply(ArquillianContainer arquillianContainer) {
            return arquillianContainer.getId();
        }
    });

    public static ArquillianContainersAppManager getInstance() {
        return (ArquillianContainersAppManager)ServiceManager.getService(ArquillianContainersAppManager.class);
    }

    private static List<ArquillianContainer> createEmbeddedContainers() {
        return Arrays.asList(new ArquillianContainerEmbedded("embedded.glassfish.3.1", "GlassFish Embedded 3.1", "http://arquillian.org/modules/arquillian-glassfish-embedded-3.1-container-adapter/", ArquillianGlassfishEmbedded_3_1.class), new ArquillianContainerEmbedded("embedded.jboss.as.6.x", "JBoss AS Embedded 6.x", "http://arquillian.org/modules/arquillian-jbossas-embedded-6-container-adapter/", ArquillianJBossEmbedded_6_x.class), new ArquillianContainerEmbedded("embedded.jetty.6", "Jetty Embedded 6.x", "http://arquillian.org/modules/arquillian-jetty-embedded-6.1-container-adapter/", ArquillianJettyEmbedded_6_1_x.class), new ArquillianContainerEmbedded("embedded.jetty.7-8", "Jetty Embedded 7-8.x", "http://arquillian.org/modules/arquillian-jetty-embedded-7-container-adapter/", ArquillianJettyEmbedded_7and8_x.class), new ArquillianContainerEmbedded("embedded.jetty.9", "Jetty Embedded 9.x", "http://arquillian.org/modules/arquillian-jetty-embedded-9-container-adapter/", ArquillianJettyEmbedded_9_x.class), new ArquillianContainerEmbedded("embedded.open-web-beans", "OpenWebBeans Embedded 1.x", "http://arquillian.org/modules/arquillian-openwebbeans-embedded-1-container-adapter/", ArquillianOpenWebBeansEmbedded_1_x.class), new ArquillianContainerEmbedded("embedded.osgi-jboss", "OSGi :: JBoss", "http://arquillian.org/modules/arquillian-osgi-jbosgi-embedded-container-adapter/", ArquillianOSGiContainerJBossEmbedded.class), new ArquillianContainerEmbedded("embedded.osgi-felix", "OSGi :: Felix", "http://arquillian.org/modules/arquillian-osgi-felix-embedded-container-adapter/", ArquillianOSGiContainerFelixEmbedded.class), new ArquillianContainerEmbedded("embedded.osgi-equinox", "OSGi :: Equinox", "http://arquillian.org/modules/arquillian-osgi-equinox-embedded-container-adapter/", ArquillianOSGiContainerEquinoxEmbedded.class), new ArquillianContainerEmbedded("embedded.osgi-karaf", "OSGi :: Karaf", "http://arquillian.org/modules/arquillian-osgi-karaf-embedded-container-adapter/", ArquillianOSGiContainerKarafEmbedded.class), new ArquillianContainerEmbedded("embedded.resin", "Resin Embedded 4", "http://arquillian.org/modules/arquillian-resin-embedded-4-container-adapter/", ArquillianResinEmbedded_4.class), new ArquillianContainerEmbedded("embedded.open-ejb", "OpenEJB", "http://arquillian.org/modules/arquillian-openejb-embedded-4-container-adapter/", ArquillianOpenEJB.class), new ArquillianContainerEmbedded("embedded.tomcat.6.x", "Tomcat Embedded 6.x", "http://arquillian.org/modules/arquillian-tomcat-embedded-6-container-adapter/", ArquillianTomcatEmbedded_6_x.class), new ArquillianContainerEmbedded("embedded.tomcat.7.x", "Tomcat Embedded 7.x", "http://arquillian.org/modules/arquillian-tomcat-embedded-7-container-adapter/", ArquillianTomcatEmbedded_7_x.class), new ArquillianContainerEmbedded("embedded.tomcat.8.x", "Tomcat Embedded 8.x", "http://arquillian.org/modules/arquillian-tomcat-embedded-8-container-adapter/", ArquillianTomcatEmbedded_8_x.class), new ArquillianContainerEmbedded("embedded.tom-ee", "TomEE Embedded", "http://arquillian.org/modules/arquillian-tomee-embedded-container-adapter/", ArquillianTomEEEmbedded.class), new ArquillianContainerEmbedded("embedded.undertow", "Undertow Embedded", "http://arquillian.org/modules/undertow-embedded-container-adapter/", ArquillianUndertowEmbedded.class), new ArquillianContainerEmbedded("embedded.web-logic.12.1", "WebLogic Embedded 12.1", "http://arquillian.org/modules/arquillian-wls-embedded-12.1-container-adapter/", ArquillianWebLogicEmbedded_12_1.class), new ArquillianContainerEmbedded("embedded.web-sphere.as.8.x", "WebSphere AS Embedded 8.x", "http://arquillian.org/modules/arquillian-was-embedded-8-container-adapter/", ArquillianWebSphereASEmbedded_8_x.class), new ArquillianContainerEmbedded("embedded.weld.ee.1.1", "Weld EE Embedded 1.1.x", "http://arquillian.org/modules/arquillian-weld-ee-embedded-1.1-container-adapter/", ArquillianWeldEEEmbedded_1_1_x.class), new ArquillianContainerEmbedded("embedded.weld.se.1", "Weld SE Embedded 1.x", "http://arquillian.org/modules/arquillian-weld-se-embedded-1-container-adapter/", ArquillianWeldSEEmbedded_1_x.class, SimpleLoggingFacadeForJava.class), new ArquillianContainerEmbedded("embedded.weld.se.1.1", "Weld SE Embedded 1.1.x", "http://arquillian.org/modules/arquillian-weld-se-embedded-1.1-container-adapter/", ArquillianWeldSEEmbedded_1_1_x.class), new ArquillianContainerEmbedded("embedded.wild-fly", "WildFly Embedded", "http://arquillian.org/modules/wildfly-arquillian-wildfly-embedded-container-adapter/", ArquillianWildFlyEmbedded.class));
    }

    private static List<ArquillianContainer> createManualContainers() {
        return Collections.singletonList(new ArquillianContainerManual());
    }

    private static List<ArquillianContainer> createManagedContainers() {
        return Lists.newArrayList();
    }

    private static List<ArquillianContainer> createRemoteContainers() {
        return Lists.newArrayList();
    }

    @NotNull
    public List<ArquillianContainer> getContainers(ArquillianContainer.Scope scope) {
        switch (scope) {
            default: {
                List<ArquillianContainer> list = this.manualContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Embedded: {
                List<ArquillianContainer> list = this.embeddedContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Managed: {
                List<ArquillianContainer> list = this.managedContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Remote: 
        }
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getEmbeddedContainers() {
        List<ArquillianContainer> list = this.embeddedContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getEmbeddedContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManagedContainers() {
        List<ArquillianContainer> list = this.managedContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getManagedContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManualContainers() {
        List<ArquillianContainer> list = this.manualContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getManualContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getRemoteContainers() {
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getRemoteContainers"));
        }
        return list;
    }

    @Nullable
    public ArquillianContainer findContainerById(String id) {
        return this.registeredContainers.get(id);
    }
}

