/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Base64Converter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.ws.rest.client.RESTCookiesPanel;
import com.intellij.ws.rest.client.RestClientController;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientCustomActionsProvider;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestPanel;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponseListener;
import com.intellij.ws.rest.client.RestClientSettings;
import com.intellij.ws.rest.client.UsernamePasswordForm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.http.cookie.Cookie;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RESTClient
implements RestClientResponseListener,
Disposable {
    public static final String REST_CLIENT_REQUEST_TAG = "RestClientRequest";
    private final Project myProject;
    private TextFieldWithHistory myHttpMethod;
    private ComboBox myURL;
    private VirtualFile myResponseFile;
    private EditorEx myResponse;
    private FileType mySelectedResponseFileType = PlainTextFileType.INSTANCE;
    private final Ref<FileType> myFileTypeFromResponse;
    private final Set<FileType> myBuiltinFileTypes;
    private JPanel myMainPanel;
    private final EditorTextField myHeader;
    private JTextField myURLBase;
    private final JLabel myStatus;
    private final JPanel myResponseTab;
    private JPanel myMainToolbarPlaceholder;
    private JPanel myRequestPanel;
    private JPanel myTabsPlaceholder;
    private JTextField myURLTextField;
    private final RestClientController myController;
    private final JPanel myWrappedMainPanel;
    private final RestClientRequestPanel myClientRequestPanel;
    private boolean myHaveURLTemplates;
    private final RESTCookiesPanel myCookiesPanel;
    private final JBTabs myTabs;
    private final DumbAwareAction myReformatAction;

    public RESTClient(Project project) {
        this.$$$setupUI$$$();
        this.myFileTypeFromResponse = new Ref((Object)PlainTextFileType.INSTANCE);
        this.myBuiltinFileTypes = new HashSet<FileType>();
        this.myWrappedMainPanel = new RestHelpWrapper();
        this.myProject = project;
        this.myController = new RestClientControllerImpl(project);
        this.myResponseTab = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myClientRequestPanel = new RestClientRequestPanel(project, this);
        this.myCookiesPanel = new RESTCookiesPanel(project, this);
        this.myReformatAction = new ReformatAction();
        this.initUIComponents();
        this.myRequestPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)0, (int)0));
        this.myWrappedMainPanel.add(this.myMainPanel);
        this.myHeader = new MyEditorTextField(this.myProject, true);
        this.myTabs = new JBRunnerTabs(project, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project), (Disposable)project);
        this.myTabs.getPresentation().setInnerInsets(new Insets(0, 0, 0, 0)).setPaintBorder(0, 0, 0, 0).setPaintFocus(false).setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.getComponent().setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)1, (int)0, (int)0));
        this.myTabs.addTab(new TabInfo((JComponent)this.myClientRequestPanel).setText("Request"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myCookiesPanel).setText("Cookies"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myResponseTab).setText("Response"));
        this.myTabs.addTab(new TabInfo((JComponent)this.myHeader).setText("Response Headers"));
        this.myTabsPlaceholder.add((Component)this.myTabs.getComponent(), "Center");
        this.createMainToolbar();
        this.createResponseToolbar();
        this.myStatus = new JLabel();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myStatus);
        this.myResponseTab.add("South", this.myStatus);
        this.myHttpMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RESTClient.this.updateBodyEnabled();
            }
        });
        List<RestClientRequest> history = RestClientSettings.getInstance((Project)project).REQUEST_HISTORY;
        if (history.size() > 0) {
            this.loadRequestFromHistory(history.get(0));
        }
        this.updateBodyEnabled();
        this.myClientRequestPanel.updateFileEnabled();
    }

    private void updateBodyEnabled() {
        String item = (String)this.myHttpMethod.getSelectedItem();
        this.myClientRequestPanel.setCanHasBody("POST".equals(item) || "PUT".equals(item) || "PATCH".equals(item));
    }

    private void createMainToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        DumbAwareAction submitRequestAction = new DumbAwareAction("Submit Request", "", AllIcons.Actions.Execute){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$2", "actionPerformed"));
                }
                RESTClient.this.onGoToUrlAction(new RestClientRequestProcessor[0]);
            }
        };
        submitRequestAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, (JComponent)this.myMainPanel);
        group.add((AnAction)submitRequestAction);
        for (RestClientCustomActionsProvider provider : (RestClientCustomActionsProvider[])Extensions.getExtensions(RestClientCustomActionsProvider.EP_NAME)) {
            group.addAll(provider.getCustomActions(this));
        }
        group.add((AnAction)new DumbAwareAction("Update resource paths from code", "", AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$3", "actionPerformed"));
                }
                RESTClient.this.updateResourcePaths();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$3", "update"));
                }
                e.getPresentation().setVisible(((RestClientDataProvider[])Extensions.getExtensions(RestClientDataProvider.EP_NAME)).length > 0);
            }
        });
        RequestHistoryAction historyAction = new RequestHistoryAction();
        historyAction.registerCustomShortcutSet(CommonShortcuts.getRecentFiles(), this.myMainPanel);
        group.add((AnAction)historyAction);
        group.add((AnAction)new ExportRequestAction());
        group.add((AnAction)new ImportRequestAction());
        group.add((AnAction)new GenerateAuthAction());
        group.add((AnAction)new ConfigureProxyAction());
        group.add((AnAction)new DumbAwareAction("Close", null, AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$4", "actionPerformed"));
                }
                Disposer.dispose((Disposable)RESTClient.this);
            }
        });
        group.add((AnAction)new ContextHelpAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false);
        this.myMainToolbarPlaceholder.add((Component)toolbar.getComponent(), "West");
    }

    private void updateResourcePaths() {
        HashSet<String> allPaths = new HashSet<String>();
        for (RestClientDataProvider provider : (RestClientDataProvider[])Extensions.getExtensions(RestClientDataProvider.EP_NAME)) {
            ContainerUtil.addAll(allPaths, (Object[])provider.getAllPaths(this.myProject));
        }
        this.setURLTemplates(allPaths);
        this.myClientRequestPanel.updateHeaderEditor();
    }

    private void createResponseToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myReformatAction);
        group.add((AnAction)new OpenInBrowserAction());
        group.add((AnAction)new HighlightAction(this, "View as text", "PLAIN_TEXT", AllIcons.FileTypes.Text));
        group.add((AnAction)new HighlightAction(this, "View as HTML", "HTML", AllIcons.FileTypes.Html));
        group.add((AnAction)new HighlightAction(this, "View as XML", "XML", AllIcons.FileTypes.Xml));
        group.add((AnAction)new HighlightAction(this, "View as JSON", "JSON", AllIcons.FileTypes.Json));
        group.add((AnAction)new HighlightAction(this, "View according to MIME type", this.myFileTypeFromResponse, AllIcons.FileTypes.Custom));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false);
        this.myResponseTab.add((Component)toolbar.getComponent(), "West");
    }

    private RestClientRequest createRequest() {
        RestClientRequest request = this.getRequest();
        this.myClientRequestPanel.saveToRequest(request);
        this.myCookiesPanel.saveToRequest(request);
        return request;
    }

    public String getRequestURL() {
        return this.getRequest().getURL();
    }

    @NotNull
    private RestClientRequest getRequest() {
        RestClientRequest request = new RestClientRequest();
        request.httpMethod = this.getHttpMethod();
        request.urlBase = this.myURLBase.getText();
        request.urlPath = this.getURL();
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/client/RESTClient", "getRequest"));
        }
        return restClientRequest;
    }

    private String getURL() {
        if (this.myHaveURLTemplates) {
            return (String)this.myURL.getEditor().getItem();
        }
        return this.myURLTextField.getText();
    }

    private void loadRequestFromHistory(RestClientRequest request) {
        this.myHttpMethod.setSelectedItem((Object)request.httpMethod);
        this.myURLBase.setText(request.urlBase);
        this.setURL(request.urlPath);
        this.myClientRequestPanel.loadFromRequest(request);
        this.myCookiesPanel.loadFromRequest(request);
        this.myTabs.select(this.myTabs.getTabAt(0), false);
    }

    private void setURL(String path) {
        if (this.myHaveURLTemplates) {
            this.myURL.getEditor().setItem(path);
        } else {
            this.myURLTextField.setText(path);
        }
    }

    @Override
    public void setResponseHeader(String header) {
        this.myHeader.setText(header == null ? "" : header);
    }

    public void setURLTemplates(Set<String> templates) {
        this.myHaveURLTemplates = !templates.isEmpty();
        this.myURL.setVisible(this.myHaveURLTemplates);
        this.myURLTextField.setVisible(!this.myHaveURLTemplates);
        if (!templates.isEmpty()) {
            this.myURL.removeAllItems();
            for (String template : templates) {
                this.myURL.addItem((Object)template);
            }
            this.myURL.addItem((Object)"/application.wadl");
        }
    }

    private String getResponse() {
        return this.myResponse.getDocument().getText();
    }

    @Override
    public void setResponse(String response, @Nullable String mimeType) {
        FileType fileType = RestClientFileUtil.findFileType(mimeType);
        RestClientFileUtil.deleteFile(this.myResponseFile);
        this.myResponseFile = RestClientFileUtil.createFile(response, fileType);
        this.updateEditor(FileDocumentManager.getInstance().getDocument(this.myResponseFile), fileType);
        this.mySelectedResponseFileType = fileType;
        this.myFileTypeFromResponse.set((Object)fileType);
    }

    private void updateEditor(Document document, FileType fileType) {
        EditorEx oldResponse = this.myResponse;
        this.myResponse = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, fileType, true);
        this.setHighlighting(document, false);
        this.myResponse.getSettings().setUseSoftWraps(true);
        this.myResponse.getSettings().setLineMarkerAreaShown(false);
        this.myResponse.getSettings().setLineNumbersShown(false);
        this.myReformatAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ReformatCode").getShortcutSet(), this.myResponse.getComponent(), (Disposable)this);
        this.myResponseTab.add((Component)this.myResponse.getComponent(), "Center");
        this.myResponseTab.validate();
        if (oldResponse != null) {
            this.setHighlighting((Document)oldResponse.getDocument(), true);
            this.myReformatAction.unregisterCustomShortcutSet(oldResponse.getComponent());
            this.myResponseTab.remove(oldResponse.getComponent());
            EditorFactory.getInstance().releaseEditor((Editor)oldResponse);
        }
    }

    private void setHighlighting(Document document, boolean value) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile != null) {
            HighlightingSettingsPerFile.getInstance((Project)this.myProject).setHighlightingSettingForRoot((PsiElement)psiFile, value ? FileHighlightingSetting.NONE : FileHighlightingSetting.SKIP_INSPECTION);
        }
    }

    public String getHttpMethod() {
        return (String)this.myHttpMethod.getSelectedItem();
    }

    private void createUIComponents() {
        this.myHttpMethod = new TextFieldWithStoredHistory("RESTClient.httpMethod");
        this.myHttpMethod.setHistorySize(15);
        ArrayList<String> newHistory = new ArrayList<String>(Arrays.asList("GET", "POST", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS"));
        for (String method : this.myHttpMethod.getHistory()) {
            if (newHistory.contains(method)) continue;
            newHistory.add(method);
        }
        this.myHttpMethod.setHistory(newHistory);
        this.myHttpMethod.setSelectedIndex(0);
    }

    private void initUIComponents() {
        this.myURLBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                RESTClient.this.myURLBase.setBackground(RESTClient.this.myController.isValidURL(RESTClient.this.myURLBase.getText()) ? UIUtil.getTextFieldBackground() : new JBColor((Color)JBColor.PINK, new Color(75, 34, 27)));
            }
        });
        KeyAdapter enterListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getKeyCode() == 10) {
                    RESTClient.this.onGoToUrlAction(new RestClientRequestProcessor[0]);
                }
            }
        };
        this.myURLBase.addKeyListener(enterListener);
        this.myURL.getEditor().getEditorComponent().addKeyListener(enterListener);
        this.myURLTextField.addKeyListener(enterListener);
        this.updateResourcePaths();
        this.myURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int end;
                int start;
                String s = (String)RESTClient.this.myURL.getSelectedItem();
                if (s == null) {
                    return;
                }
                if (s.contains("{") && s.contains("}") && (start = s.indexOf("{")) < (end = s.indexOf("}"))) {
                    ((JTextField)RESTClient.this.myURL.getEditor().getEditorComponent()).setSelectionStart(start);
                    ((JTextField)RESTClient.this.myURL.getEditor().getEditorComponent()).setSelectionEnd(end + 1);
                }
            }
        });
        this.updateEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.mySelectedResponseFileType);
    }

    public void onGoToUrlAction(RestClientRequestProcessor ... processors) {
        if (processors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processors", "com/intellij/ws/rest/client/RESTClient", "onGoToUrlAction"));
        }
        this.myClientRequestPanel.stopEditing();
        this.splitParameters();
        this.myTabs.select(this.myTabs.getTabAt(2), false);
        this.myResponse.getContentComponent().requestFocus();
        this.myController.onGoButtonClick(this.createRequest(), this, processors);
        this.myHttpMethod.addCurrentTextToHistory();
    }

    private void splitParameters() {
        URI uri;
        try {
            uri = new URI(this.myURLBase.getText());
        }
        catch (URISyntaxException ex) {
            return;
        }
        String path = uri.getPath();
        if (!StringUtil.isEmpty((String)path)) {
            this.setURL(path);
            String query = uri.getQuery();
            if (query != null) {
                this.addParameters(query);
            }
            try {
                URI uriWithoutPath = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, query, null);
                this.myURLBase.setText(uriWithoutPath.toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            path = this.getURL();
            int queryStart = path.indexOf(63);
            if (queryStart > 0) {
                this.addParameters(path.substring(queryStart + 1));
                this.setURL(path.substring(0, queryStart));
            }
        }
    }

    private void addParameters(String query) {
        for (String s : StringUtil.split((String)query, (String)"&")) {
            int pos = s.indexOf(61);
            if (pos <= 0) continue;
            this.myClientRequestPanel.addRequestParameter(s.substring(0, pos), s.substring(pos + 1));
        }
    }

    public JComponent getComponent() {
        return this.myWrappedMainPanel;
    }

    public void dispose() {
        if (this.myResponse != null && !this.myResponse.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myResponse);
        }
        RestClientFileUtil.deleteFile(this.myResponseFile);
    }

    @Override
    public void setStatus(String status) {
        this.myStatus.setText(status);
    }

    @Override
    public void setCookies(Collection<Cookie> cookies) {
        this.myCookiesPanel.setCookies(cookies);
    }

    public void importRequest(VirtualFile file) {
        org.jdom.Document document;
        try {
            document = JDOMUtil.loadDocument((InputStream)file.getInputStream());
        }
        catch (JDOMException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)("The selected file is not a valid .xml file: " + e.getMessage()), (String)"Error Loading Request");
            return;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Error loading " + file.getPath() + ": " + e.getMessage()), (String)"Error Loading Request");
            return;
        }
        if (!document.getRootElement().getName().equals(REST_CLIENT_REQUEST_TAG)) {
            Messages.showErrorDialog((Project)this.myProject, (String)"The selected file is not a REST Client request", (String)"Error Loading Request");
        }
        RestClientRequest request = (RestClientRequest)XmlSerializer.deserialize((org.jdom.Document)document, RestClientRequest.class);
        this.loadRequestFromHistory(request);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JTextField jTextField2;
        ComboBox comboBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myRequestPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, new Dimension(35, 25), null));
        TextFieldWithHistory textFieldWithHistory = this.myHttpMethod;
        textFieldWithHistory.setPopupVisible(false);
        jPanel3.add((Component)textFieldWithHistory, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myURL = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel3.add((Component)comboBox, new GridConstraints(0, 6, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myURLBase = jTextField2 = new JTextField();
        jTextField2.setColumns(40);
        jTextField2.setText("http://localhost:8080/resources");
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myURLTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 5, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("HTTP method:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Host/port:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Path:");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTabsPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setName("Response");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMainToolbarPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 2, 1, 0, 3, 0, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ReformatAction
    extends DumbAwareAction {
        public ReformatAction() {
            super("Reformat response", null, AllIcons.Actions.ToggleSoftWrap);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ReformatAction", "actionPerformed"));
            }
            PsiFile file = PsiManager.getInstance((Project)RESTClient.this.myProject).findFile(RESTClient.this.myResponseFile);
            new ReformatCodeProcessor(RESTClient.this.myProject, new PsiFile[]{file}, "Reformat response", null, false).run();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ReformatAction", "update"));
            }
            e.getPresentation().setEnabled(e.getProject() != null && RESTClient.this.myResponse.getDocument().getTextLength() > 0);
        }
    }

    static class MyEditorTextField
    extends EditorTextField {
        public MyEditorTextField(Project project, boolean viewer) {
            super(EditorFactory.getInstance().createDocument((CharSequence)""), project, (FileType)PlainTextFileType.INSTANCE, viewer, false);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.getSettings().setUseSoftWraps(true);
            editor.setVerticalScrollbarVisible(true);
            return editor;
        }
    }

    private class ImportRequestAction
    extends DumbAwareAction {
        private ImportRequestAction() {
            super("Import Request", "Load request from an .xml file", AllIcons.ToolbarDecorator.Import);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ImportRequestAction", "actionPerformed"));
            }
            FileTypeDescriptor descriptor = new FileTypeDescriptor("Select .xml File with REST Client Request", new String[]{"xml"});
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, (Component)RESTClient.this.myMainPanel, (VirtualFile)RESTClient.this.myProject.getBaseDir(), (Consumer)new FileChooser.FileChooserConsumer(){

                public void consume(List<VirtualFile> files) {
                    if (files.size() > 0) {
                        RESTClient.this.importRequest(files.get(0));
                    }
                }

                public void cancelled() {
                }
            });
        }
    }

    private class ExportRequestAction
    extends DumbAwareAction {
        private ExportRequestAction() {
            super("Export Request", "Save current request to .xml file", AllIcons.ToolbarDecorator.Export);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ExportRequestAction", "actionPerformed"));
            }
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Request as XML", "", new String[]{"xml"}), ExportRequestAction.getEventProject((AnActionEvent)e));
            VirtualFileWrapper file = dialog.save(null, null);
            if (file != null) {
                RestClientRequest request = RESTClient.this.createRequest();
                Element requestXml = XmlSerializer.serialize((Object)request);
                try (Writer printWriter = null;){
                    printWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getFile()), CharsetToolkit.UTF8_CHARSET));
                    JDOMUtil.writeElement((Element)requestXml, (Writer)printWriter, (String)"\n");
                }
                catch (IOException e1) {
                    Messages.showErrorDialog((Project)RESTClient.this.myProject, (String)e1.getMessage(), (String)"Export Request Failed");
                }
            }
        }
    }

    private class RequestHistoryAction
    extends DumbAwareAction {
        private RequestHistoryAction() {
            super("Replay Recent Requests", "Show and replay recently executed requests", AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Component c;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$RequestHistoryAction", "actionPerformed"));
            }
            List<RestClientRequest> history = RestClientSettings.getInstance((Project)((RESTClient)RESTClient.this).myProject).REQUEST_HISTORY;
            BaseListPopupStep<RestClientRequest> step = new BaseListPopupStep<RestClientRequest>("Recent Requests", history){

                public PopupStep onChosen(RestClientRequest selectedValue, boolean finalChoice) {
                    RESTClient.this.loadRequestFromHistory(selectedValue);
                    return FINAL_CHOICE;
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            InputEvent event = e.getInputEvent();
            Component component = c = event != null ? event.getComponent() : null;
            if (c != null) {
                popup.showUnderneathOf(c);
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$RequestHistoryAction", "update"));
            }
            e.getPresentation().setEnabled(RestClientSettings.getInstance((Project)((RESTClient)RESTClient.this).myProject).REQUEST_HISTORY.size() > 0);
        }
    }

    private class GenerateAuthAction
    extends DumbAwareAction {
        private GenerateAuthAction() {
            super("Generate 'Authorization' Header", "Generates a header for HTTP basic authorization from a username and a password", AllIcons.Nodes.SecurityRole);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$GenerateAuthAction", "actionPerformed"));
            }
            UsernamePasswordForm form = new UsernamePasswordForm(RESTClient.this.myMainPanel);
            if (form.showAndGet()) {
                String decoded = form.getUsername() + ":" + form.getPassword();
                String encoded = Base64Converter.encode((byte[])decoded.getBytes(CharsetToolkit.UTF8_CHARSET));
                RESTClient.this.myClientRequestPanel.setHeader("Authorization", "Basic " + encoded);
            }
        }
    }

    private static class RestHelpWrapper
    extends JPanel
    implements TypeSafeDataProvider {
        public RestHelpWrapper() {
            super(new BorderLayout());
        }

        public void calcData(DataKey key, DataSink sink) {
            if (PlatformDataKeys.HELP_ID.equals(key)) {
                sink.put(key, (Object)"reference.tool.windows.rest.client");
            }
        }
    }

    private class OpenInBrowserAction
    extends DumbAwareAction {
        private OpenInBrowserAction() {
            super("Open in Browser", "Open response content in browser", AllIcons.Nodes.PpWeb);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$OpenInBrowserAction", "actionPerformed"));
            }
            RESTClient.this.myController.openResponseInBrowser(RESTClient.this.getResponse());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$OpenInBrowserAction", "update"));
            }
            e.getPresentation().setEnabled(e.getProject() != null && RESTClient.this.myResponse.getDocument().getTextLength() > 0);
        }
    }

    private class HighlightAction
    extends ToggleAction
    implements DumbAware {
        private final Ref<FileType> myFileType;
        final /* synthetic */ RESTClient this$0;

        public HighlightAction(RESTClient rESTClient, @NotNull String text, String fileType, Icon icon) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ws/rest/client/RESTClient$HighlightAction", "<init>"));
            }
            this(rESTClient, text, (Ref<FileType>)Ref.create((Object)FileTypeManager.getInstance().findFileTypeByName(fileType)), icon);
        }

        public HighlightAction(RESTClient rESTClient, @NotNull String text, Ref<FileType> fileType, Icon icon) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ws/rest/client/RESTClient$HighlightAction", "<init>"));
            }
            this.this$0 = rESTClient;
            super(text, null, icon);
            this.myFileType = fileType;
            if (!this.isMimeTypeRef(fileType)) {
                rESTClient.myBuiltinFileTypes.add(fileType.get());
            }
        }

        private FileType getFileType() {
            return (FileType)this.myFileType.get();
        }

        private boolean isMimeTypeRef(Ref<FileType> fileType) {
            return fileType == this.this$0.myFileTypeFromResponse;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.this$0.mySelectedResponseFileType == this.getFileType();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (!state) {
                return;
            }
            RestClientFileUtil.deleteFile(this.this$0.myResponseFile);
            FileType fileType = this.getFileType();
            this.this$0.myResponseFile = RestClientFileUtil.createFile(this.this$0.myResponse.getDocument().getText(), fileType);
            this.this$0.updateEditor(FileDocumentManager.getInstance().getDocument(this.this$0.myResponseFile), fileType);
            this.this$0.mySelectedResponseFileType = fileType;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(e.getProject() != null && this.this$0.myResponse.getDocument().getTextLength() > 0);
            if (this.isMimeTypeRef(this.myFileType)) {
                e.getPresentation().setVisible(!this.this$0.myBuiltinFileTypes.contains(this.getFileType()));
            }
            super.update(e);
        }
    }

    private class ConfigureProxyAction
    extends DumbAwareAction {
        private ConfigureProxyAction() {
            super("Configure HTTP Proxy", "Show dialog to configure the HTTP proxy settings", AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/rest/client/RESTClient$ConfigureProxyAction", "actionPerformed"));
            }
            HttpConfigurable.editConfigurable((JComponent)RESTClient.this.myMainPanel);
        }
    }
}

