/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.spring.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.SpringInitializrOptionsLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SpringInitializrApplicationInfoStep
extends ModuleWizardStep
implements Disposable {
    private static final String NAME = "Name";
    private static final String GROUP = "Group";
    private static final String ARTIFACT = "Artifact";
    private static final String VERSION = "Version";
    private static final String PACKAGE = "Package";
    private final SpringInitializrModuleBuilder myBuilder;
    private final JBLoadingPanel myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
    private JBTextField myGroupField;
    private JBTextField myArtifactField;
    private JBTextField myVersionField;
    private JBTextField myNameField;
    private JBTextField myDescriptionField;
    private JBTextField myPackageNameField;

    SpringInitializrApplicationInfoStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    public boolean validate() throws ConfigurationException {
        if (this.myBuilder.getOptions() == null) {
            throw new ConfigurationException("Initialization failed for\n'" + this.myBuilder.getServiceUrl() + "'\n" + "cannot proceed");
        }
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myNameField, NAME);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myGroupField, GROUP);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myArtifactField, ARTIFACT);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myVersionField, VERSION);
        SpringInitializrApplicationInfoStep.validateRequiredField(this.myPackageNameField, PACKAGE);
        String packageNameValue = this.myPackageNameField.getText();
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(packageNameValue)) {
            throw new ConfigurationException(packageNameValue + " is not a valid package name");
        }
        return true;
    }

    private static void validateRequiredField(JBTextField field, String name) throws ConfigurationException {
        if (field.getText().isEmpty()) {
            throw new ConfigurationException(name + " must be set");
        }
    }

    public void _init() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        if (options == null) {
            this.loadSpringInitializrOptions();
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public JComponent getPreferredFocusedComponent() {
        return UIUtil.findComponentOfType((JComponent)this.myPanel, JBTextField.class);
    }

    private void loadSpringInitializrOptions() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpringInitializrApplicationInfoStep.this.myPanel.getContentPanel().removeAll();
                        SpringInitializrApplicationInfoStep.this.myPanel.startLoading();
                    }
                });
                final String serviceUrl = SpringInitializrApplicationInfoStep.this.myBuilder.getServiceUrl();
                try {
                    EmptyProgressIndicator delegatingProgressIndicator = new EmptyProgressIndicator(){

                        public void setText(final String text) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SpringInitializrApplicationInfoStep.this.myPanel.setLoadingText(text);
                                }
                            });
                        }
                    };
                    SpringInitializrOptionsLoader loader = new SpringInitializrOptionsLoader(serviceUrl);
                    final SpringInitializrOptions options = loader.loadOptions((ProgressIndicator)delegatingProgressIndicator);
                    SpringInitializrApplicationInfoStep.this.myBuilder.setOptions(options);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpringInitializrApplicationInfoStep.this.createSpringBootPanel(options);
                        }
                    });
                }
                catch (IOException e) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((String)("Initialization failed for '" + serviceUrl + "'\n" + "Please check URL, network and proxy settings.\n\n" + "Error message:\n" + e.getMessage()), (String)"Spring Initializr Error");
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SpringInitializrApplicationInfoStep.this.myPanel.stopLoading();
                                SpringInitializrApplicationInfoStep.this.myPanel.revalidate();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void createSpringBootPanel(SpringInitializrOptions options) {
        if (options == null) {
            return;
        }
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder();
        this.myNameField = builder.addTextField(NAME, options.name);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SpringInitializrApplicationInfoStep.this.myArtifactField.setText(StringUtil.toLowerCase((String)StringUtil.sanitizeJavaIdentifier((String)SpringInitializrApplicationInfoStep.this.myNameField.getText())));
            }
        });
        builder.addVerticalSpacing();
        builder.addComboBox("Type", options.type);
        builder.addComboBox("Packaging", options.packaging);
        builder.addComboBox("Java Version", options.javaVersion);
        builder.addComboBox("Language", options.language);
        builder.addVerticalSpacing();
        this.myGroupField = builder.addTextField(GROUP, options.group);
        this.myGroupField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SpringInitializrApplicationInfoStep.this.myPackageNameField.setText(StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myGroupField.getText()));
            }
        });
        this.myArtifactField = builder.addTextField(ARTIFACT, options.artifact);
        this.myVersionField = builder.addTextField(VERSION, options.version);
        builder.addVerticalSpacing();
        this.myDescriptionField = builder.addTextField("Description", options.description);
        this.myPackageNameField = builder.addTextField(PACKAGE, options.packageName);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)builder.getPanel(), (boolean)true), (Object)"North");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    public void updateDataModel() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        options.name = this.myNameField.getText();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
        options.version = this.myVersionField.getText();
        options.description = this.myDescriptionField.getText();
        options.packageName = this.myPackageNameField.getText();
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }
}

