/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSCloudAgent;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.OSDomainConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl;
import org.jetbrains.annotations.NotNull;

public class OSServerRuntimeInstance
extends CloudMultiSourceServerRuntimeInstance<OSDeploymentConfiguration, OSCloudAgentConfig, OSCloudAgent, OSCloudConfiguration>
implements SshKeyAwareServerRuntime {
    private static final String SPECIFICS_MODULE_NAME = "OpenShiftSrv";
    private static final String SPECIFICS_JAR_PATH = "specifics/openShiftSpecifics.jar";
    private final RemoteServer<OSCloudConfiguration> myServer;

    public OSServerRuntimeInstance(RemoteServer<OSCloudConfiguration> server, ServerTaskExecutor taskExecutor, List<File> clientLibrary) throws Exception {
        super((ServerType)OSCloudType.getInstance(), (CloudAgentConfigBase)server.getConfiguration(), taskExecutor, clientLibrary, Arrays.asList(DatatypeFactoryImpl.class), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, OSCloudAgent.class, "com.intellij.javaee.openshift.agent.cloud.OSCloudAgentImpl");
        this.myServer = server;
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, OSDeploymentConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/openshift/cloud/OSServerRuntimeInstance", "getDeploymentName"));
        }
        String string = configuration.getDeploymentSourceName(source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OSServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/openshift/cloud/OSServerRuntimeInstance", "getDeploymentName"));
        }
        throw new UnsupportedOperationException();
    }

    protected void doConnect(OSCloudConfiguration configuration, CloudAgentLogger logger) {
        ((OSCloudAgent)this.getAgent()).connect(configuration, (CloudAgentErrorHandler)this.getAgentTaskExecutor(), logger);
    }

    public void addSshKey(final File sshKey) throws ServerRuntimeException {
        this.getAgentTaskExecutor().execute((Computable)new Computable<Object>(){

            public Object compute() {
                ((OSCloudAgent)OSServerRuntimeInstance.this.getAgent()).addSshKeyFile(sshKey);
                return null;
            }
        });
    }

    public CloudServerRuntimeInstance asCloudServerRuntime() {
        return this;
    }

    public RemoteServer getServer() {
        return this.myServer;
    }

    public OSDomainConfiguration getConfigurationDomain() throws ServerRuntimeException {
        return (OSDomainConfiguration)this.getAgentTaskExecutor().execute((Computable)new Computable<OSDomainConfiguration>(){

            public OSDomainConfiguration compute() {
                return ((OSCloudAgent)OSServerRuntimeInstance.this.getAgent()).getConfigurationDomain();
            }
        });
    }

    public String[] getAvailableDomains() throws ServerRuntimeException {
        return (String[])this.getAgentTaskExecutor().execute((Computable)new Computable<String[]>(){

            public String[] compute() {
                return ((OSCloudAgent)OSServerRuntimeInstance.this.getAgent()).getAvailableDomains();
            }
        });
    }
}

