/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.ant;

import com.springsource.bundlor.ant.BundlorExecutor;
import com.springsource.bundlor.ant.ManifestTemplate;
import com.springsource.bundlor.ant.OsgiProfile;
import com.springsource.bundlor.ant.internal.AntBundlorExecutor;
import com.springsource.bundlor.ant.internal.Configuration;
import com.springsource.bundlor.ant.internal.support.StandardConfigurationValidator;
import com.springsource.bundlor.ant.internal.support.StandardManifestTemplateFactory;
import com.springsource.bundlor.ant.internal.support.StandardOsgiProfileFactory;
import com.springsource.bundlor.ant.internal.support.StandardPropertiesSourceFactory;
import com.springsource.bundlor.support.classpath.StandardClassPathFactory;
import com.springsource.bundlor.support.manifestwriter.StandardManifestWriterFactory;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.springframework.util.StringUtils;

public class Bundlor {
    private final Configuration configuration = new Configuration();
    private volatile boolean failOnWarnings = false;
    private volatile boolean enabled = true;

    public final void setFailOnWarnings(boolean failOnWarnings) {
        this.failOnWarnings = failOnWarnings;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setInputPath(String inputPath) {
        this.configuration.setInputPath(inputPath);
    }

    public final void setOutputPath(String outputPath) {
        this.configuration.setOutputPath(outputPath);
    }

    public final void setManifestTemplatePath(String manifestTemplatePath) {
        this.configuration.setManifestTemplatePath(manifestTemplatePath);
    }

    public final void addConfiguredManifestTemplate(ManifestTemplate manifestTemplate) {
        this.configuration.setManifestTemplate(manifestTemplate.getTemplate());
    }

    public final void setOsgiProfilePath(String osgiProfilePath) {
        this.configuration.setOsgiProfilePath(osgiProfilePath);
    }

    public final void addConfiguredOsgiProfile(OsgiProfile osgiProfile) {
        this.configuration.setOsgiProfile(osgiProfile.getProfile());
    }

    public final void setBundleSymbolicName(String bundleSymbolicName) {
        this.configuration.setBundleSymbolicName(bundleSymbolicName);
    }

    public final void setBundleVersion(String bundleVersion) {
        this.configuration.setBundleVersion(bundleVersion);
    }

    public final void setPropertiesPath(String propertiesPath) {
        this.configuration.setPropertiesPath(propertiesPath);
    }

    public final void addPropertySet(PropertySet propertySet) {
        this.configuration.addPropertySet(propertySet);
    }

    public final void addProperty(Property property) {
        this.configuration.addProperty(property);
    }

    public final void execute() {
        if (!this.enabled) {
            return;
        }
        List<String> warnings = this.getBundlorExecutor().execute();
        if (warnings.size() > 0) {
            System.out.println("Bundlor Warnings:");
            for (String warning : warnings) {
                System.out.println("    " + warning);
            }
            if (this.failOnWarnings) {
                String message = StringUtils.hasText(this.configuration.getManifestTemplatePath()) ? String.format("Bundlor returned warnings.  Please fix manifest template at '%s' and try again.", this.configuration.getManifestTemplatePath()) : "Bundlor returned warnings.  Please fix inline manifest template and try again.";
                throw new BuildException(message);
            }
        }
    }

    protected BundlorExecutor getBundlorExecutor() {
        return new AntBundlorExecutor(this.configuration, new StandardConfigurationValidator(), new StandardClassPathFactory(), new StandardManifestWriterFactory(), new StandardManifestTemplateFactory(), new StandardPropertiesSourceFactory(), new StandardOsgiProfileFactory());
    }
}

