/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.websocket.jam.SpringMessageMapping;
import com.intellij.spring.websocket.jam.SpringMessagingUrlAnnotation;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.SpringMessagingUrlDefinition;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringMessagingUrlMethodAnnotation
extends SpringMessagingUrlAnnotation<PsiMethod>
implements SpringMessagingUrlDefinition {
    @Override
    @Nullable
    public SpringMessageMapping.ClassMapping getClassMapping() {
        Module module;
        PsiMethod psiMethod = (PsiMethod)this.getPsiElement();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) != null) {
            return (SpringMessageMapping.ClassMapping)JamService.getJamService((Project)module.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringMessageMapping.ClassMapping.META});
        }
        return null;
    }

    @Override
    @Nullable
    public SpringMessagingType getMessagingType() {
        return SpringMessagingType.byClass(this.getClass());
    }

    @Override
    @NotNull
    public List<UrlPointer> getUrlPointers() {
        List<JamStringAttributeElement<String>> urls = this.getUrls();
        if (urls.size() == 0) {
            SmartList smartList = new SmartList((Object)new UrlPointer(this.getNavigationElement(), ""));
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingUrlMethodAnnotation", "getUrlPointers"));
            }
            return smartList;
        }
        List list = ContainerUtil.map(urls, (Function)new Function<JamStringAttributeElement<String>, UrlPointer>(){

            public UrlPointer fun(JamStringAttributeElement<String> element) {
                return new UrlPointer(element);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/jam/SpringMessagingUrlMethodAnnotation", "getUrlPointers"));
        }
        return list;
    }
}

