/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.providers;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.websocket.model.messaging.SpringMessagingModel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringMessagingGotoSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/providers/SpringMessagingGotoSymbolProvider", "addNames"));
        }
        SpringMessagingModel model = new SpringMessagingModel(module);
        result.addAll(ContainerUtil.mapNotNull(model.getAllUrls(), (Function)new Function<SpringMessagingModel.Variant, String>(){

            public String fun(SpringMessagingModel.Variant variant) {
                return variant.presentation;
            }
        }));
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/providers/SpringMessagingGotoSymbolProvider", "addItems"));
        }
        SpringMessagingModel model = new SpringMessagingModel(module);
        for (SpringMessagingModel.Variant variant : model.getAllUrls()) {
            PsiElement target;
            if (!name.equals(variant.presentation) || (target = variant.urlDefinition.getPsiElement()) == null) continue;
            result.add(SpringMessagingGotoSymbolProvider.createNavigationItem((PsiElement)target, (String)variant.presentation, null));
        }
    }

    protected boolean acceptModule(Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        return javaPsiFacade.findClass("org.springframework.messaging.handler.annotation.MessageMapping", searchScope) != null;
    }
}

