/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.WaitForProgressToShow;
import javax.swing.Icon;

public class MessageManager {
    private static final Logger LOG = Logger.getInstance((String)MessageManager.class.getName());

    public static void showMessageDialog(final Project project, final String msg, final String title, final Icon icon) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Messages.showMessageDialog((Project)project, (String)msg, (String)title, (Icon)icon);
            }
        };
        MessageManager.runShowAction(runnable);
    }

    public static void runShowAction(Runnable runnable) {
        try {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)runnable);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public static int showDialog(final Project project, final String msg, final String title, final String[] options, final int defaultOptionIndex, final Icon icon) {
        final int[] result = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                result[0] = Messages.showDialog((Project)project, (String)msg, (String)title, (String[])options, (int)defaultOptionIndex, (Icon)icon);
            }
        };
        MessageManager.runShowAction(runnable);
        return result[0];
    }
}

